/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.files;

import com.google.common.io.ByteStreams;
import io.lumine.mythic.bukkit.utils.config.ConfigurationLoader;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.bukkit.plugin.java.JavaPlugin;

public class Files {
    public static final String SEP = System.getProperty("file.separator");
    public static File BACKUP_FOLDER = null;

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    Files.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public static List<File> getAll(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        ArrayList<File> resultList = new ArrayList<File>();
        for (File file : fList = directory.listFiles()) {
            if (file.isFile() && (file.getName().endsWith(".yml") || file.getName().endsWith(".txt"))) {
                resultList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            resultList.addAll(Files.getAll(file.getAbsolutePath()));
        }
        return resultList;
    }

    public static String toList(String s2, File[] list) {
        for (File f : list) {
            s2 = (String)s2 + f.getName() + ", ";
        }
        return s2;
    }

    public static List<File> getAllYaml(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        ArrayList<File> resultList = new ArrayList<File>();
        for (File file : fList = directory.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".yml")) {
                resultList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            resultList.addAll(Files.getAllYaml(file.getAbsolutePath()));
        }
        return resultList;
    }

    public static List<File> getAll(String directoryName, Collection<String> extensions) {
        File[] fList;
        File directory = new File(directoryName);
        ArrayList<File> resultList = new ArrayList<File>();
        for (File file : fList = directory.listFiles()) {
            if (file.isFile()) {
                String ext;
                String[] split = file.getName().split("\\.");
                if (split.length < 2 || !extensions.contains(ext = split[split.length - 1].toLowerCase())) continue;
                resultList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            resultList.addAll(Files.getAll(file.getAbsolutePath(), extensions));
        }
        return resultList;
    }

    public static <T extends LuminePlugin> List<ConfigurationLoader<T>> getConfigurationLoaders(T plugin, List<File> files, String folder) {
        ArrayList<ConfigurationLoader<T>> list = new ArrayList<ConfigurationLoader<T>>();
        for (File file : files) {
            list.add(new ConfigurationLoader<T>(plugin, file, folder));
        }
        return list;
    }

    public static void copyResource(JavaPlugin plugin, File file, String path) {
        if (!file.exists()) {
            try {
                FileOutputStream writer = new FileOutputStream(file);
                InputStream reader = plugin.getResource(path);
                if (reader != null) {
                    ByteStreams.copy((InputStream)reader, (OutputStream)writer);
                }
                ((OutputStream)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyResource(JavaPlugin plugin, File origin, String resourceOrigin, String path) {
        Files.copyResource(plugin, Files.createFile(origin, path), resourceOrigin + "/" + path);
    }

    public static String createPath(String ... path) {
        if (path.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(path[0]);
        for (int i = 1; i < path.length; ++i) {
            builder.append(SEP).append(path[i]);
        }
        return builder.toString();
    }

    public static File createDirectory(File parent, String ... path) {
        String compactPath = Files.createPath(path);
        File file = new File(parent, compactPath);
        if (!file.exists() && !file.mkdirs()) {
            Log.error("Failed to create directory: " + compactPath);
        }
        return file;
    }

    public static File createFile(File parent, String ... path) {
        File file = new File(parent, Files.createPath(path));
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            Log.error("Failed to create file.");
        }
        return file;
    }

    public static File createFileOrEmpty(File parent, String ... path) {
        String compactPath = Files.createPath(path);
        File file = new File(parent, compactPath);
        try {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs() || !file.exists() && !file.createNewFile()) {
                Log.error("Failed to create file: " + compactPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static BufferedImage toImage(String data) {
        String[] d = data.split(",");
        if (d.length > 1) {
            return Files.rawToImage(d[1]);
        }
        return Files.rawToImage(data);
    }

    public static BufferedImage rawToImage(String data) {
        try {
            byte[] imageBytes = Base64.getDecoder().decode(data);
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String removeExtension(String path) {
        int id = path.lastIndexOf(".");
        if (id == -1) {
            return path;
        }
        return path.substring(0, id);
    }

    public static boolean isExtension(String path, String extensions) {
        int id = path.lastIndexOf(".");
        if (id == -1) {
            return false;
        }
        return path.substring(id + 1).equalsIgnoreCase(extensions);
    }

    public static void copyDirectory(Path source, Path target) throws IOException {
        java.nio.file.Files.walk(source, new FileVisitOption[0]).forEach(sourcePath -> {
            Path targetPath = target.resolve(source.relativize((Path)sourcePath));
            try {
                if (java.nio.file.Files.isDirectory(sourcePath, new LinkOption[0])) {
                    if (!java.nio.file.Files.exists(targetPath, new LinkOption[0])) {
                        java.nio.file.Files.createDirectories(targetPath, new FileAttribute[0]);
                    }
                } else {
                    java.nio.file.Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

