/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.LocProp;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import io.lumine.mythic.bukkit.utils.serialize.Zone;
import org.bukkit.configuration.ConfigurationSection;

public class ZoneProp
extends PropertyType<Zone> {
    private final LocProp min;
    private final LocProp max;

    public ZoneProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.min = new LocProp(plugin, file, node + ".Min", Locus.of(0.0, 0.0, 0.0));
        this.max = new LocProp(plugin, file, node + ".Max", Locus.of(0.0, 0.0, 0.0));
    }

    public ZoneProp(LuminePlugin plugin, Object file, String node, Zone defaultValue) {
        super(plugin, file, node);
        this.min = new LocProp(plugin, file, node + ".Min", defaultValue.getMin());
        this.max = new LocProp(plugin, file, node + ".Max", defaultValue.getMax());
    }

    @Override
    protected Zone compute(ConfigurationSection section, String node) {
        return Zone.of((Locus)this.min.get(section), (Locus)this.max.get(section));
    }

    @Override
    protected Zone getDefaultValue() {
        return Zone.of(this.min.getDefaultValue(), this.max.getDefaultValue());
    }

    @Override
    public void set(String holder, Zone value) {
        if (this.config == null) {
            return;
        }
        this.min.set(holder, value.getMin());
        this.max.set(holder, value.getMax());
    }
}

