/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.collections.WeightedCollection;
import io.lumine.mythic.bukkit.utils.collections.WeightedEntry;
import io.lumine.mythic.bukkit.utils.config.LineConfig;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class WeightedLineItemListProp
extends PropertyType<WeightedCollection<WeightedEntry<ItemStack>>> {
    private WeightedCollection<WeightedEntry<ItemStack>> defaultValue = new WeightedCollection();
    private StringListProp LIST;

    public WeightedLineItemListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.LIST = new StringListProp(plugin, file, node);
        WeightedEntry<ItemStack> defaultValuea = new WeightedEntry<ItemStack>(new ItemStack(Material.STONE), 1.0);
        this.defaultValue.add(defaultValuea);
    }

    public WeightedLineItemListProp(LuminePlugin plugin, Object file, String node, WeightedCollection<WeightedEntry<ItemStack>> defaultValue) {
        super(plugin, file, node);
        this.LIST = new StringListProp(plugin, file, node);
        this.defaultValue = defaultValue;
    }

    @Override
    protected WeightedCollection<WeightedEntry<ItemStack>> compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.defaultValue;
        }
        WeightedCollection<WeightedEntry<ItemStack>> items = new WeightedCollection<WeightedEntry<ItemStack>>();
        for (String line : (List)this.LIST.get(section)) {
            double weight;
            LineConfig lc;
            block5: {
                lc = LineConfig.of(line);
                String[] lineSplit = lc.getLine().split(" ");
                if (lineSplit.length > 1) {
                    try {
                        weight = Double.parseDouble(lineSplit[1]);
                        break block5;
                    }
                    catch (Error | Exception ex) {
                        Log.info("Invalid entry weight {0} on line {1}", lineSplit[1], line);
                        continue;
                    }
                }
                weight = 1.0;
            }
            ItemStack item = ItemFactory.of(lc).build();
            items.add(new WeightedEntry<ItemStack>(item, weight));
        }
        return items;
    }

    @Override
    public void set(String holder, WeightedCollection<WeightedEntry<ItemStack>> value) {
        if (this.config == null) {
            return;
        }
    }

    @Override
    public WeightedCollection<WeightedEntry<ItemStack>> getDefaultValue() {
        return this.defaultValue;
    }
}

