/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class StringListProp
extends PropertyType<List<String>> {
    private final List<String> defaultValue;

    public StringListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.defaultValue = new ArrayList<String>();
    }

    public StringListProp(LuminePlugin plugin, Object file, String node, List<String> defaultValue) {
        super(plugin, file, node);
        this.defaultValue = defaultValue;
    }

    @Override
    protected List<String> compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.defaultValue;
        }
        if (!section.isSet(node)) {
            return this.defaultValue;
        }
        List prop = section.getStringList(node);
        if (prop == null) {
            return this.defaultValue;
        }
        return section.getStringList(node);
    }

    @Override
    public List<String> getDefaultValue() {
        return this.defaultValue;
    }
}

