/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.BlockLocus;
import io.lumine.mythic.bukkit.utils.serialize.BlockOrient;
import io.lumine.mythic.bukkit.utils.serialize.Direction;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class BlockOrientListProp
extends PropertyType<List<BlockOrient>> {
    public BlockOrientListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    @Override
    protected List<BlockOrient> compute(ConfigurationSection section, String node) {
        ArrayList<BlockOrient> result = new ArrayList<BlockOrient>();
        if (section == null) {
            return result;
        }
        List listprop = section.getStringList(node);
        if (listprop == null) {
            return result;
        }
        for (String prop : listprop) {
            try {
                String[] split = prop.split(",");
                int x = Integer.valueOf(split[0]);
                int y = Integer.valueOf(split[1]);
                int z = Integer.valueOf(split[2]);
                float yaw = split.length > 3 ? Float.valueOf(split[3]).floatValue() : 0.0f;
                float pitch = split.length > 4 ? Float.valueOf(split[4]).floatValue() : 0.0f;
                result.add(BlockOrient.of(BlockLocus.of(x, y, z), Direction.of(yaw, pitch)));
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected List<BlockOrient> getDefaultValue() {
        return Collections.emptyList();
    }

    @Override
    public void set(String holder, List<BlockOrient> value) {
        if (this.config == null) {
            return;
        }
        ArrayList<CallSite> out = new ArrayList<CallSite>();
        for (BlockOrient orient : value) {
            String o = orient.getLocus().getX() + "," + orient.getLocus().getY() + "," + orient.getLocus().getZ() + "," + orient.getDirection().getYaw() + "," + orient.getDirection().getPitch();
            out.add((CallSite)((Object)o));
        }
        this.config.set(this.node, out);
    }
}

