/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.caffeine.cache;

import io.lumine.mythic.bukkit.utils.caffeine.cache.Node;
import io.lumine.mythic.bukkit.utils.caffeine.cache.NodeFactory;
import io.lumine.mythic.bukkit.utils.caffeine.cache.References;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;

class FS<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final VarHandle KEY;
    protected static final VarHandle VALUE;
    volatile References.WeakKeyReference<K> key;
    volatile V value;

    FS() {
    }

    FS(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        this(new References.WeakKeyReference<K>(key, keyReferenceQueue), value, valueReferenceQueue, weight, now);
    }

    FS(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        KEY.set(this, keyReference);
        VALUE.set(this, value);
    }

    @Override
    public final K getKey() {
        return (K)KEY.get(this).get();
    }

    @Override
    public final Object getKeyReference() {
        return KEY.get(this);
    }

    @Override
    public final V getValue() {
        return (V)VALUE.get(this);
    }

    @Override
    public final Object getValueReference() {
        return VALUE.get(this);
    }

    @Override
    public final void setValue(V value, ReferenceQueue<V> referenceQueue) {
        VALUE.set(this, value);
    }

    @Override
    public final boolean containsValue(Object value) {
        return Objects.equals(value, this.getValue());
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FS<K, V>(key, keyReferenceQueue, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FS<K, V>(keyReference, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Object newLookupKey(Object key) {
        return new References.LookupKeyReference<Object>(key);
    }

    @Override
    public Object newReferenceKey(K key, ReferenceQueue<K> referenceQueue) {
        return new References.WeakKeyReference<K>(key, referenceQueue);
    }

    @Override
    public final boolean isAlive() {
        Object key = this.getKeyReference();
        return key != RETIRED_WEAK_KEY && key != DEAD_WEAK_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_WEAK_KEY;
    }

    @Override
    public final void retire() {
        KEY.set(this, RETIRED_WEAK_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_WEAK_KEY;
    }

    @Override
    public final void die() {
        VALUE.set(this, null);
        KEY.set(this, DEAD_WEAK_KEY);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            KEY = lookup.findVarHandle(FS.class, "key", References.WeakKeyReference.class);
            VALUE = lookup.findVarHandle(FS.class, "value", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

