/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.events;

import io.lumine.mythic.api.adapters.AbstractDirection;
import io.lumine.mythic.api.adapters.AbstractLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerActionPacketEvent
extends Event
implements Cancellable {
    private final Player player;
    private final Action action;
    private final AbstractLocation location;
    private final AbstractDirection direction;
    private boolean cancelled = false;
    private static final HandlerList handlers = new HandlerList();

    public PlayerActionPacketEvent(Player player, Action action, AbstractLocation location, AbstractDirection direction) {
        super(true);
        this.player = player;
        this.action = action;
        this.location = location;
        this.direction = direction;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Action getAction() {
        return this.action;
    }

    public AbstractLocation getLocation() {
        return this.location;
    }

    public AbstractDirection getDirection() {
        return this.direction;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerActionPacketEvent)) {
            return false;
        }
        PlayerActionPacketEvent other = (PlayerActionPacketEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        AbstractLocation this$location = this.getLocation();
        AbstractLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        AbstractDirection this$direction = this.getDirection();
        AbstractDirection other$direction = other.getDirection();
        return !(this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerActionPacketEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        AbstractLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        AbstractDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        return result;
    }

    public String toString() {
        return "PlayerActionPacketEvent(player=" + String.valueOf(this.getPlayer()) + ", action=" + String.valueOf((Object)this.getAction()) + ", location=" + String.valueOf(this.getLocation()) + ", direction=" + String.valueOf((Object)this.getDirection()) + ", cancelled=" + this.isCancelled() + ")";
    }

    public static enum Action {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        DROP_ALL_ITEMS,
        DROP_ITEM,
        RELEASE_USE_ITEM,
        SWAP_ITEM_WITH_OFFHAND,
        STAB;

    }
}

