/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.events;

import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.heal.HealMetadata;
import io.lumine.mythic.bukkit.utils.Events;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jetbrains.annotations.NotNull;

public class MythicHealMechanicEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    boolean cancelled = false;
    private final SkillMetadata metadata;
    private final HealMetadata healMeta;

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public Entity getTarget() {
        return this.healMeta.getTarget().getBukkitEntity();
    }

    public double getHealAmount() {
        return this.healMeta.getAmount();
    }

    public void setHealAmount(double heal) {
        this.healMeta.setAmount(heal);
    }

    public double getFinalAmount() {
        return this.healMeta.getAmount() * this.healMeta.getMultiplier();
    }

    public MythicHealMechanicEvent(@NotNull SkillMetadata metadata, @NotNull HealMetadata healMeta) {
        super(healMeta.getHealer().getEntity().getBukkitEntity());
        this.metadata = metadata;
        this.healMeta = healMeta;
    }

    public static MythicHealMechanicEvent call(@NotNull SkillMetadata metadata, @NotNull HealMetadata healMeta) {
        MythicHealMechanicEvent mythicEvent = new MythicHealMechanicEvent(metadata, healMeta);
        Events.callSync((Event)mythicEvent);
        if (mythicEvent.isCancelled()) {
            return mythicEvent;
        }
        EntityRegainHealthEvent bukkitEvent = new EntityRegainHealthEvent(healMeta.getTarget().getBukkitEntity(), mythicEvent.getFinalAmount(), EntityRegainHealthEvent.RegainReason.CUSTOM);
        Events.callSync((Event)bukkitEvent);
        if (bukkitEvent.isCancelled()) {
            mythicEvent.setCancelled(true);
            return mythicEvent;
        }
        mythicEvent.setHealAmount(bukkitEvent.getAmount());
        return mythicEvent;
    }

    public SkillMetadata getMetadata() {
        return this.metadata;
    }

    public HealMetadata getHealMeta() {
        return this.healMeta;
    }
}

