/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities.properties;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.drops.IItemDrop;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.entities.properties.EntityPropertySet;
import io.lumine.mythic.bukkit.utils.serialize.InventorySerialization;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class MerchantProperty
implements EntityPropertySet {
    private final MythicConfig mc;
    private int level;
    private boolean hasTrades = true;
    private boolean hasDynamicTrades = false;
    private List<ConfigTrade> trades;

    public MerchantProperty(MythicConfig mc) {
        this.mc = mc;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            this.level = mc.getInteger("Options.TradingLevel", 1);
            this.level = mc.getInteger("Options.Level", this.level);
        }
        this.hasTrades = mc.getBoolean("Options.HasTrades", true);
        if (mc.isSet("DynamicTrades")) {
            this.hasDynamicTrades = true;
        }
        if (mc.isSet("Trades")) {
            this.trades = new ArrayList<ConfigTrade>();
            for (MythicConfig tradeConf : mc.getNestedConfigs("Trades").values()) {
                try {
                    int configItemAmount;
                    String configItem;
                    String[] spItem;
                    int resultAmount;
                    String result;
                    String strResult = tradeConf.getString("Result", "STONE");
                    String strItem1 = tradeConf.getString("Item1", "5 EMERALD");
                    String strItem2 = tradeConf.getString("Item2", null);
                    PlaceholderInt maxUses = PlaceholderInt.of(tradeConf.getString("MaxUses", "10000"));
                    String[] spResult = strResult.split(" ");
                    if (spResult.length == 1) {
                        result = spResult[0];
                        resultAmount = 1;
                    } else if (spResult.length > 1) {
                        result = spResult[1];
                        try {
                            resultAmount = Integer.parseInt(spResult[0]);
                        }
                        catch (NumberFormatException exception) {
                            resultAmount = 0;
                        }
                    } else {
                        result = "STONE";
                        resultAmount = 0;
                    }
                    ConfigTrade recipe = new ConfigTrade(result, resultAmount, maxUses);
                    if (strItem1 != null) {
                        spItem = strItem1.split(" ");
                        configItem = null;
                        configItemAmount = 0;
                        if (spItem.length == 1) {
                            configItem = spItem[0];
                            configItemAmount = 1;
                        } else if (spItem.length > 1) {
                            configItem = spItem[1];
                            try {
                                configItemAmount = Integer.parseInt(spItem[0]);
                            }
                            catch (NumberFormatException exception) {
                                configItemAmount = 0;
                            }
                        }
                        recipe.setConfigItem1(configItem);
                        recipe.setAmount1(configItemAmount);
                    }
                    if (strItem2 != null) {
                        spItem = strItem2.split(" ");
                        configItem = null;
                        configItemAmount = 0;
                        if (spItem.length == 1) {
                            configItem = spItem[0];
                            configItemAmount = 1;
                        } else if (spItem.length > 1) {
                            configItem = spItem[1];
                            try {
                                configItemAmount = Integer.parseInt(spItem[0]);
                            }
                            catch (NumberFormatException exception) {
                                configItemAmount = 0;
                            }
                        }
                        recipe.setConfigItem2(configItem);
                        recipe.setAmount2(configItemAmount);
                    }
                    this.trades.add(recipe);
                }
                catch (Throwable ex) {
                    MythicLogger.errorGenericConfig("A villager trade with result " + tradeConf.getString("Result", "STONE") + " is configured incorrectly.");
                }
            }
        }
    }

    public boolean hasTrades() {
        return this.trades != null && !this.trades.isEmpty() || this.hasDynamicTrades;
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if (!(entity instanceof Merchant)) {
            return entity;
        }
        Merchant merchant = (Merchant)entity;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.setVillagerLevel(this.level);
        }
        if (this.hasTrades()) {
            ArrayList trades = Lists.newArrayList();
            if (this.trades != null) {
                for (ConfigTrade trade : this.trades) {
                    try {
                        trades.add(trade.toMerchantRecipe());
                    }
                    catch (Throwable ex) {
                        MythicLogger.errorGenericConfig("Failed to process Villager Trade with result " + trade.getConfigResult());
                    }
                }
            }
            if (this.hasDynamicTrades) {
                for (MythicConfig tradeConf : this.mc.getNestedConfigs("DynamicTrades").values()) {
                    MerchantRecipe recipe = this.getDynamicRecipe(entity, tradeConf);
                    if (recipe == null) continue;
                    trades.add(recipe);
                }
            }
            merchant.setRecipes((List)trades);
        } else {
            merchant.setRecipes(Collections.emptyList());
        }
        return entity;
    }

    private MerchantRecipe getDynamicRecipe(Entity entity, MythicConfig tradeConf) {
        try {
            int amount;
            ItemStack result;
            String strResult = tradeConf.getString("Result", "STONE");
            String strItem1 = tradeConf.getString("Item1", "5 EMERALD");
            String strItem2 = tradeConf.getString("Item2", null);
            PlaceholderInt maxUses = tradeConf.getPlaceholderInt("MaxUses", "10000");
            String[] spResult = strResult.split(" ");
            ItemStack itemStack = result = spResult.length == 1 ? MerchantProperty.getItemFromTable(entity, spResult[0]) : MerchantProperty.getItemFromTable(entity, spResult[1]);
            if (result.getType() != Material.PLAYER_HEAD) {
                result = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(result));
            }
            if (spResult.length == 2) {
                int amount2;
                try {
                    amount2 = Integer.parseInt(spResult[0]);
                }
                catch (NumberFormatException exception) {
                    amount2 = 0;
                }
                result.setAmount(amount2);
            }
            MerchantRecipe recipe = new MerchantRecipe(result, maxUses.get());
            if (strItem1 != null) {
                String[] spItem1 = strItem1.split(" ");
                ItemStack item1 = spItem1.length == 1 ? MerchantProperty.getItemFromTable(entity, spItem1[0]) : MerchantProperty.getItemFromTable(entity, spItem1[1]);
                item1 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item1));
                if (spItem1.length == 2) {
                    try {
                        amount = Integer.parseInt(spItem1[0]);
                    }
                    catch (NumberFormatException exception) {
                        amount = 0;
                    }
                    item1.setAmount(amount);
                }
                recipe.addIngredient(item1);
            }
            if (strItem2 != null) {
                String[] spItem2 = strItem2.split(" ");
                ItemStack item2 = spItem2.length == 1 ? MerchantProperty.getItemFromTable(entity, spItem2[0]) : MerchantProperty.getItemFromTable(entity, spItem2[1]);
                item2 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item2));
                if (spItem2.length == 2) {
                    try {
                        amount = Integer.parseInt(spItem2[0]);
                    }
                    catch (NumberFormatException exception) {
                        amount = 0;
                    }
                    item2.setAmount(amount);
                }
                recipe.addIngredient(item2);
            }
            return recipe;
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("A villager trade with result " + tradeConf.getString("Result", "STONE") + " is configured incorrectly.");
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemFromTable(Entity entity, String itemString) {
        DropTable table;
        Optional<DropTable> maybeTable = MythicBukkit.inst().getDropManager().getDropTable(itemString);
        if (maybeTable.isPresent()) {
            table = maybeTable.get();
        } else {
            if (itemString.startsWith("\"")) {
                try {
                    itemString = itemString.substring(1, itemString.length() - 1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                itemString = SkillString.parseMessageSpecialChars(itemString);
            }
            ArrayList items = Lists.newArrayList();
            for (String s2 : itemString.split(",")) {
                items.add(s2);
            }
            table = new DropTable("DropItemMechanic", "DropItemMechanic", items);
        }
        AbstractEntity aEntity = BukkitAdapter.adapt(entity);
        DropMetadataImpl meta = new DropMetadataImpl(new GenericCaster(aEntity), aEntity);
        ItemStack ret = new ItemStack(Material.AIR);
        for (Drop type : table.generate(meta).getDrops()) {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) continue;
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (!(drop instanceof IItemDrop)) continue;
            IItemDrop itemDrop = (IItemDrop)drop;
            ret = BukkitAdapter.adapt(itemDrop.getDrop(meta, amount));
            break;
        }
        return ret;
    }

    private class ConfigTrade {
        private final String configResult;
        private final int amountResult;
        private final PlaceholderInt maxUses;
        private String configItem1 = null;
        private int amount1 = 1;
        private String configItem2 = null;
        private int amount2 = 1;

        public MerchantRecipe toMerchantRecipe() {
            ItemStack itemResult = BukkitAdapter.adapt(MythicBukkit.inst().getBootstrap().createItem(this.configResult));
            itemResult.setAmount(this.amountResult);
            MerchantRecipe recipe = new MerchantRecipe(itemResult, this.maxUses.get());
            if (this.configItem1 != null) {
                ItemStack item1 = BukkitAdapter.adapt(MythicBukkit.inst().getBootstrap().createItem(this.configItem1));
                item1 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item1));
                if (this.amount1 > 1) {
                    item1.setAmount(this.amount1);
                }
                recipe.addIngredient(item1);
            }
            if (this.configItem2 != null) {
                ItemStack item2 = BukkitAdapter.adapt(MythicBukkit.inst().getBootstrap().createItem(this.configItem2));
                item2 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item2));
                if (this.amount2 > 1) {
                    item2.setAmount(this.amount2);
                }
                recipe.addIngredient(item2);
            }
            return recipe;
        }

        public ConfigTrade(String configResult, int amountResult, PlaceholderInt maxUses) {
            this.configResult = configResult;
            this.amountResult = amountResult;
            this.maxUses = maxUses;
        }

        public String getConfigResult() {
            return this.configResult;
        }

        public int getAmountResult() {
            return this.amountResult;
        }

        public PlaceholderInt getMaxUses() {
            return this.maxUses;
        }

        public String getConfigItem1() {
            return this.configItem1;
        }

        public int getAmount1() {
            return this.amount1;
        }

        public String getConfigItem2() {
            return this.configItem2;
        }

        public int getAmount2() {
            return this.amount2;
        }

        public void setConfigItem1(String configItem1) {
            this.configItem1 = configItem1;
        }

        public void setAmount1(int amount1) {
            this.amount1 = amount1;
        }

        public void setConfigItem2(String configItem2) {
            this.configItem2 = configItem2;
        }

        public void setAmount2(int amount2) {
            this.amount2 = amount2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigTrade)) {
                return false;
            }
            ConfigTrade other = (ConfigTrade)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmountResult() != other.getAmountResult()) {
                return false;
            }
            if (this.getAmount1() != other.getAmount1()) {
                return false;
            }
            if (this.getAmount2() != other.getAmount2()) {
                return false;
            }
            String this$configResult = this.getConfigResult();
            String other$configResult = other.getConfigResult();
            if (this$configResult == null ? other$configResult != null : !this$configResult.equals(other$configResult)) {
                return false;
            }
            PlaceholderInt this$maxUses = this.getMaxUses();
            PlaceholderInt other$maxUses = other.getMaxUses();
            if (this$maxUses == null ? other$maxUses != null : !this$maxUses.equals(other$maxUses)) {
                return false;
            }
            String this$configItem1 = this.getConfigItem1();
            String other$configItem1 = other.getConfigItem1();
            if (this$configItem1 == null ? other$configItem1 != null : !this$configItem1.equals(other$configItem1)) {
                return false;
            }
            String this$configItem2 = this.getConfigItem2();
            String other$configItem2 = other.getConfigItem2();
            return !(this$configItem2 == null ? other$configItem2 != null : !this$configItem2.equals(other$configItem2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigTrade;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmountResult();
            result = result * 59 + this.getAmount1();
            result = result * 59 + this.getAmount2();
            String $configResult = this.getConfigResult();
            result = result * 59 + ($configResult == null ? 43 : $configResult.hashCode());
            PlaceholderInt $maxUses = this.getMaxUses();
            result = result * 59 + ($maxUses == null ? 43 : $maxUses.hashCode());
            String $configItem1 = this.getConfigItem1();
            result = result * 59 + ($configItem1 == null ? 43 : $configItem1.hashCode());
            String $configItem2 = this.getConfigItem2();
            result = result * 59 + ($configItem2 == null ? 43 : $configItem2.hashCode());
            return result;
        }

        public String toString() {
            return "MerchantProperty.ConfigTrade(configResult=" + this.getConfigResult() + ", amountResult=" + this.getAmountResult() + ", maxUses=" + String.valueOf(this.getMaxUses()) + ", configItem1=" + this.getConfigItem1() + ", amount1=" + this.getAmount1() + ", configItem2=" + this.getConfigItem2() + ", amount2=" + this.getAmount2() + ")";
        }
    }
}

