/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;

public class BukkitSkeleton
extends BukkitEntityType {
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.SKELETON_SKULL).build();
    private boolean preventConversion = false;

    @Override
    public EntityType getBukkitType() {
        return EntityType.SKELETON;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.preventConversion = mc.getBoolean("Options.PreventConversion", false);
    }

    @Override
    public Entity applyOptions(Entity e) {
        Skeleton skeleton = (Skeleton)e;
        if (this.preventConversion) {
            skeleton.setConversionTime(Integer.MAX_VALUE);
        }
        return skeleton;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }

    public boolean isPreventConversion() {
        return this.preventConversion;
    }
}

