/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.core.logging.MythicLogger;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;
import org.bukkit.inventory.ItemStack;

public class BukkitShulker
extends BukkitEntityType {
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.SHULKER_BOX).build();
    private DyeColor color;

    @Override
    public EntityType getBukkitType() {
        return EntityType.SHULKER;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        try {
            this.color = DyeColor.valueOf((String)mc.getString("Options.Color", "PURPLE"));
        }
        catch (Exception exception) {
            MythicLogger.errorGenericConfig("Invalid dye color specified");
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Shulker e = (Shulker)entity;
        e.setColor(this.color);
        return e;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }

    public DyeColor getColor() {
        return this.color;
    }
}

