/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class BukkitRabbit
extends BukkitEntityType {
    private AgeableProperty ageableProperty;
    private boolean isAngry = false;
    private Rabbit.Type type;

    @Override
    public EntityType getBukkitType() {
        return EntityType.RABBIT;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.isAngry = mc.getBoolean("Options.IsKillerBunny", false);
        this.isAngry = mc.getBoolean("Options.Angry", this.isAngry);
        String t2 = mc.getString("Options.RabbitType", null);
        if (t2 != null) {
            this.type = Rabbit.Type.valueOf((String)t2.toUpperCase());
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Rabbit e = (Rabbit)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.type != null) {
            e.setRabbitType(this.type);
        }
        if (this.isAngry) {
            e.setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        }
        return e;
    }

    public AgeableProperty getAgeableProperty() {
        return this.ageableProperty;
    }

    public boolean isAngry() {
        return this.isAngry;
    }

    public Rabbit.Type getType() {
        return this.type;
    }
}

