/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Pose;
import org.bukkit.inventory.MainHand;
import org.bukkit.profile.PlayerTextures;

public class BukkitMannequin
extends BukkitEntityType {
    private boolean immovable = false;
    private boolean hideDescription = false;
    private Component description;
    private MainHand mainHand;
    private Pose pose;
    private ResolvableProfile profile;

    @Override
    public EntityType getBukkitType() {
        return EntityType.MANNEQUIN;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        String pose;
        String mainHand;
        this.immovable = mc.getBoolean("MannequinOptions.Immovable", false);
        this.hideDescription = mc.getBoolean("MannequinOptions.HideDescription", false);
        String description = mc.getString("MannequinOptions.Description", null);
        if (description != null) {
            this.description = Text.parse(description);
        }
        if ((mainHand = mc.getString("MannequinOptions.MainHand", null)) != null) {
            try {
                this.mainHand = MainHand.valueOf((String)mainHand);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((pose = mc.getString("MannequinOptions.Pose", null)) != null) {
            try {
                this.pose = Pose.valueOf((String)pose);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (mc.isSet("MannequinOptions.Player")) {
            String playerName = mc.getString("MannequinOptions.Player", "Ashijin");
            this.profile = (ResolvableProfile)ResolvableProfile.resolvableProfile().name(playerName).build();
        } else {
            String skinModel;
            Object elytra;
            Object cape;
            ResolvableProfile.SkinPatchBuilder skinBuilder = ResolvableProfile.SkinPatch.skinPatch();
            Object skin = mc.getString("MannequinOptions.Skin", null);
            if (skin != null) {
                if (!((String)skin).contains(":")) {
                    skin = "minecraft:" + (String)skin;
                }
                skinBuilder.body(Key.key((String)skin));
            }
            if ((cape = mc.getString("MannequinOptions.Cape", null)) != null) {
                if (!((String)cape).contains(":")) {
                    cape = "minecraft:" + (String)cape;
                }
                skinBuilder.cape(Key.key((String)cape));
            }
            if ((elytra = mc.getString("MannequinOptions.Elytra", null)) != null) {
                if (!((String)elytra).contains(":")) {
                    elytra = "minecraft:" + (String)elytra;
                }
                skinBuilder.elytra(Key.key((String)elytra));
            }
            if ((skinModel = mc.getString("MannequinOptions.Model", "CLASSIC")) != null) {
                try {
                    skinBuilder.model(PlayerTextures.SkinModel.valueOf((String)skinModel.toUpperCase()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.profile = (ResolvableProfile)ResolvableProfile.resolvableProfile().skinPatch((ResolvableProfile.SkinPatch)skinBuilder.build()).build();
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Mannequin mannequin = (Mannequin)entity;
        mannequin.setImmovable(this.immovable);
        if (this.description != null) {
            mannequin.setDescription(this.description);
        }
        if (this.pose != null) {
            mannequin.setPose(this.pose);
        }
        if (this.mainHand != null) {
            mannequin.setMainHand(this.mainHand);
        }
        mannequin.setProfile(this.profile);
        return mannequin;
    }

    public boolean isImmovable() {
        return this.immovable;
    }

    public boolean isHideDescription() {
        return this.hideDescription;
    }

    public Component getDescription() {
        return this.description;
    }

    public MainHand getMainHand() {
        return this.mainHand;
    }

    public Pose getPose() {
        return this.pose;
    }

    public ResolvableProfile getProfile() {
        return this.profile;
    }
}

