/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hoglin;

public class BukkitHoglin
extends BukkitEntityType {
    private AgeableProperty ageableProperty;
    private boolean ableToBeHunted = true;
    private boolean immuneToZombification = false;

    @Override
    public EntityType getBukkitType() {
        return EntityType.HOGLIN;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.ableToBeHunted = mc.getBoolean("Options.AbleToHunted", true);
        this.ableToBeHunted = mc.getBoolean("Options.Huntable", this.ableToBeHunted);
        this.immuneToZombification = mc.getBoolean("Options.ImmuneToZombification", false);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Hoglin hoglin = (Hoglin)entity;
        this.ageableProperty.applyProperties((Entity)hoglin);
        hoglin.setImmuneToZombification(this.immuneToZombification);
        hoglin.setIsAbleToBeHunted(this.ableToBeHunted);
        return hoglin;
    }

    public AgeableProperty getAgeableProperty() {
        return this.ageableProperty;
    }

    public boolean isAbleToBeHunted() {
        return this.ableToBeHunted;
    }

    public boolean isImmuneToZombification() {
        return this.immuneToZombification;
    }
}

