/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitEnderman
extends BukkitEntityType {
    private EntityType bukkitType = EntityType.ENDERMAN;
    private static final int HEIGHT = 1;
    private Material heldBlock = Material.AIR;

    @Override
    public void instantiate(MythicConfig mc) {
        try {
            this.heldBlock = Material.valueOf((String)mc.getString("Options.HeldBlock", "AIR"));
        }
        catch (Error | Exception ex) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid Material specified for Options.HeldBlock");
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Enderman e = (Enderman)entity;
        if (this.heldBlock != Material.AIR) {
            e.setCarriedBlock(this.heldBlock.createBlockData());
        }
        return entity;
    }

    @Override
    public EntityType getBukkitType() {
        return this.bukkitType;
    }

    public Material getHeldBlock() {
        return this.heldBlock;
    }
}

