/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.serialize.Orient;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.mobs.model.MobModel;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.util.BoundingBox;

public abstract class AbstractModelEngineSupport
extends ReloadableModule<MythicBukkit> {
    public AbstractModelEngineSupport(MythicBukkit plugin) {
        super(plugin);
    }

    public abstract boolean isSubHitbox(UUID var1);

    public abstract boolean isBoundToSubHitbox(UUID var1, UUID var2);

    public abstract UUID getParentUUID(UUID var1);

    public abstract AbstractEntity getParent(AbstractEntity var1);

    public abstract boolean overlapsOOBB(BoundingBox var1, AbstractEntity var2);

    public abstract ModelConfig getBoneModel(String var1, String var2) throws IllegalArgumentException;

    public abstract MobModel createMobModel(MythicMob var1, MythicConfig var2);

    public MobModel createMobModel(AbstractEntity entity, String modelId) {
        return null;
    }

    public MEGProjectile createMEGBullet(MEGProjectileData modelData, AbstractLocation location) {
        Log.error("MEG Bullets unsupported, update ModelEngine");
        return null;
    }

    public MEGAttachment createMEGAttachment(MEGAttachmentData model, AbstractEntity entity) {
        Log.error("MEG Aura Attachments unsupported, update ModelEngine");
        return null;
    }

    public abstract void queuePostModelRegistration(Runnable var1);

    public double distanceSquaredToSubHitbox(AbstractLocation origin, AbstractEntity entity) {
        BoundingBox box = entity.getBukkitEntity().getBoundingBox();
        double x = Math.max(Math.abs(origin.getX() - box.getCenterX()) - box.getWidthX() * 0.5, 0.0);
        double y = Math.max(Math.abs(origin.getY() - box.getCenterY()) - box.getHeight() * 0.5, 0.0);
        double z = Math.max(Math.abs(origin.getZ() - box.getCenterZ()) - box.getWidthZ() * 0.5, 0.0);
        return x * x + y * y + z * z;
    }

    public static enum MEGAttachmentAnchor {
        HEAD,
        BODY;

    }

    public static class MEGAttachmentData {
        private String modelId;
        private Orient offset;
        private double scale;
        private String color;
        private boolean enchanted;
        private boolean glowing;
        private String glowColor;
        private String state = null;
        private MEGAttachmentAnchor anchor = MEGAttachmentAnchor.BODY;
        private Integer brightness;
        private boolean useALOD;

        public String getModelId() {
            return this.modelId;
        }

        public Orient getOffset() {
            return this.offset;
        }

        public double getScale() {
            return this.scale;
        }

        public String getColor() {
            return this.color;
        }

        public boolean isEnchanted() {
            return this.enchanted;
        }

        public boolean isGlowing() {
            return this.glowing;
        }

        public String getGlowColor() {
            return this.glowColor;
        }

        public String getState() {
            return this.state;
        }

        public MEGAttachmentAnchor getAnchor() {
            return this.anchor;
        }

        public Integer getBrightness() {
            return this.brightness;
        }

        public boolean isUseALOD() {
            return this.useALOD;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public void setOffset(Orient offset) {
            this.offset = offset;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setEnchanted(boolean enchanted) {
            this.enchanted = enchanted;
        }

        public void setGlowing(boolean glowing) {
            this.glowing = glowing;
        }

        public void setGlowColor(String glowColor) {
            this.glowColor = glowColor;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setAnchor(MEGAttachmentAnchor anchor) {
            this.anchor = anchor;
        }

        public void setBrightness(Integer brightness) {
            this.brightness = brightness;
        }

        public void setUseALOD(boolean useALOD) {
            this.useALOD = useALOD;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MEGAttachmentData)) {
                return false;
            }
            MEGAttachmentData other = (MEGAttachmentData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getScale(), other.getScale()) != 0) {
                return false;
            }
            if (this.isEnchanted() != other.isEnchanted()) {
                return false;
            }
            if (this.isGlowing() != other.isGlowing()) {
                return false;
            }
            if (this.isUseALOD() != other.isUseALOD()) {
                return false;
            }
            Integer this$brightness = this.getBrightness();
            Integer other$brightness = other.getBrightness();
            if (this$brightness == null ? other$brightness != null : !((Object)this$brightness).equals(other$brightness)) {
                return false;
            }
            String this$modelId = this.getModelId();
            String other$modelId = other.getModelId();
            if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
                return false;
            }
            Orient this$offset = this.getOffset();
            Orient other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            String this$glowColor = this.getGlowColor();
            String other$glowColor = other.getGlowColor();
            if (this$glowColor == null ? other$glowColor != null : !this$glowColor.equals(other$glowColor)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            MEGAttachmentAnchor this$anchor = this.getAnchor();
            MEGAttachmentAnchor other$anchor = other.getAnchor();
            return !(this$anchor == null ? other$anchor != null : !((Object)((Object)this$anchor)).equals((Object)other$anchor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MEGAttachmentData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scale = Double.doubleToLongBits(this.getScale());
            result = result * 59 + (int)($scale >>> 32 ^ $scale);
            result = result * 59 + (this.isEnchanted() ? 79 : 97);
            result = result * 59 + (this.isGlowing() ? 79 : 97);
            result = result * 59 + (this.isUseALOD() ? 79 : 97);
            Integer $brightness = this.getBrightness();
            result = result * 59 + ($brightness == null ? 43 : ((Object)$brightness).hashCode());
            String $modelId = this.getModelId();
            result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
            Orient $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            String $glowColor = this.getGlowColor();
            result = result * 59 + ($glowColor == null ? 43 : $glowColor.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            MEGAttachmentAnchor $anchor = this.getAnchor();
            result = result * 59 + ($anchor == null ? 43 : ((Object)((Object)$anchor)).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractModelEngineSupport.MEGAttachmentData(modelId=" + this.getModelId() + ", offset=" + String.valueOf(this.getOffset()) + ", scale=" + this.getScale() + ", color=" + this.getColor() + ", enchanted=" + this.isEnchanted() + ", glowing=" + this.isGlowing() + ", glowColor=" + this.getGlowColor() + ", state=" + this.getState() + ", anchor=" + String.valueOf((Object)this.getAnchor()) + ", brightness=" + this.getBrightness() + ", useALOD=" + this.isUseALOD() + ")";
        }

        public MEGAttachmentData(String modelId, Orient offset, double scale, String color, boolean enchanted, boolean glowing, String glowColor, String state, MEGAttachmentAnchor anchor, Integer brightness, boolean useALOD) {
            this.modelId = modelId;
            this.offset = offset;
            this.scale = scale;
            this.color = color;
            this.enchanted = enchanted;
            this.glowing = glowing;
            this.glowColor = glowColor;
            this.state = state;
            this.anchor = anchor;
            this.brightness = brightness;
            this.useALOD = useALOD;
        }
    }

    public static interface MEGAttachment
    extends Terminable {
        public UUID getEntityId();

        default public void disableCulling() {
        }

        default public void setRenderRadius(int radius) {
        }

        default public void modelState(String state, boolean remove) {
        }
    }

    public static class MEGProjectileData {
        private String modelId;
        private double scale;
        private String color;
        private boolean enchanted;
        private boolean glowing;
        private String glowColor;
        private String state = null;
        private Integer brightness;
        private boolean useALOD;

        public String getModelId() {
            return this.modelId;
        }

        public double getScale() {
            return this.scale;
        }

        public String getColor() {
            return this.color;
        }

        public boolean isEnchanted() {
            return this.enchanted;
        }

        public boolean isGlowing() {
            return this.glowing;
        }

        public String getGlowColor() {
            return this.glowColor;
        }

        public String getState() {
            return this.state;
        }

        public Integer getBrightness() {
            return this.brightness;
        }

        public boolean isUseALOD() {
            return this.useALOD;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setEnchanted(boolean enchanted) {
            this.enchanted = enchanted;
        }

        public void setGlowing(boolean glowing) {
            this.glowing = glowing;
        }

        public void setGlowColor(String glowColor) {
            this.glowColor = glowColor;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setBrightness(Integer brightness) {
            this.brightness = brightness;
        }

        public void setUseALOD(boolean useALOD) {
            this.useALOD = useALOD;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MEGProjectileData)) {
                return false;
            }
            MEGProjectileData other = (MEGProjectileData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getScale(), other.getScale()) != 0) {
                return false;
            }
            if (this.isEnchanted() != other.isEnchanted()) {
                return false;
            }
            if (this.isGlowing() != other.isGlowing()) {
                return false;
            }
            if (this.isUseALOD() != other.isUseALOD()) {
                return false;
            }
            Integer this$brightness = this.getBrightness();
            Integer other$brightness = other.getBrightness();
            if (this$brightness == null ? other$brightness != null : !((Object)this$brightness).equals(other$brightness)) {
                return false;
            }
            String this$modelId = this.getModelId();
            String other$modelId = other.getModelId();
            if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            String this$glowColor = this.getGlowColor();
            String other$glowColor = other.getGlowColor();
            if (this$glowColor == null ? other$glowColor != null : !this$glowColor.equals(other$glowColor)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MEGProjectileData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scale = Double.doubleToLongBits(this.getScale());
            result = result * 59 + (int)($scale >>> 32 ^ $scale);
            result = result * 59 + (this.isEnchanted() ? 79 : 97);
            result = result * 59 + (this.isGlowing() ? 79 : 97);
            result = result * 59 + (this.isUseALOD() ? 79 : 97);
            Integer $brightness = this.getBrightness();
            result = result * 59 + ($brightness == null ? 43 : ((Object)$brightness).hashCode());
            String $modelId = this.getModelId();
            result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            String $glowColor = this.getGlowColor();
            result = result * 59 + ($glowColor == null ? 43 : $glowColor.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractModelEngineSupport.MEGProjectileData(modelId=" + this.getModelId() + ", scale=" + this.getScale() + ", color=" + this.getColor() + ", enchanted=" + this.isEnchanted() + ", glowing=" + this.isGlowing() + ", glowColor=" + this.getGlowColor() + ", state=" + this.getState() + ", brightness=" + this.getBrightness() + ", useALOD=" + this.isUseALOD() + ")";
        }

        public MEGProjectileData(String modelId, double scale, String color, boolean enchanted, boolean glowing, String glowColor, String state, Integer brightness, boolean useALOD) {
            this.modelId = modelId;
            this.scale = scale;
            this.color = color;
            this.enchanted = enchanted;
            this.glowing = glowing;
            this.glowColor = glowColor;
            this.state = state;
            this.brightness = brightness;
            this.useALOD = useALOD;
        }
    }

    public static interface MEGProjectile
    extends Terminable {
        public UUID getEntityId();

        public void setLocation(AbstractLocation var1);

        public void setDirection(AbstractVector var1);

        default public void disableCulling() {
        }

        default public void setRenderRadius(int radius) {
        }

        default public void modelState(String state, boolean remove) {
        }
    }

    public static class ModelConfig {
        private final int id;
        private final Material material;
        private final boolean isSmall;

        public ModelConfig(int id, Material material, boolean isSmall) {
            this.id = id;
            this.material = material;
            this.isSmall = isSmall;
        }

        public int getId() {
            return this.id;
        }

        public Material getMaterial() {
            return this.material;
        }

        public boolean isSmall() {
            return this.isSmall;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelConfig)) {
                return false;
            }
            ModelConfig other = (ModelConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.isSmall() != other.isSmall()) {
                return false;
            }
            Material this$material = this.getMaterial();
            Material other$material = other.getMaterial();
            return !(this$material == null ? other$material != null : !this$material.equals(other$material));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModelConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            result = result * 59 + (this.isSmall() ? 79 : 97);
            Material $material = this.getMaterial();
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractModelEngineSupport.ModelConfig(id=" + this.getId() + ", material=" + String.valueOf(this.getMaterial()) + ", isSmall=" + this.isSmall() + ")";
        }
    }
}

