/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GetStatsCommand
extends Command<MythicBukkit> {
    public GetStatsCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player p = (Player)sender;
        Player target = args.length > 0 ? Bukkit.getPlayer((String)args[0]) : p;
        if (target == null) {
            CommandHelper.sendError(sender, "Target not found");
            return true;
        }
        PlayerData profile = (PlayerData)((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(target);
        StatRegistry stats = profile.getStatRegistry();
        CommandHelper.sendEditorMessage(sender, "Stats for player " + target.getName() + ":");
        CommandHelper.send(sender, " ");
        for (Map.Entry<StatType, StatRegistry.StatMap> entry : stats.getStatMaps().entrySet()) {
            StatType stat = entry.getKey();
            StatRegistry.StatMap map = entry.getValue();
            double baseValue = map.getBaseValue();
            double value = stats.get(stat);
            CommandHelper.send(sender, stat.getKey() + " " + value + " (base " + baseValue + ")");
            if (!map.getAdditives().isEmpty()) {
                CommandHelper.send(sender, "\u00b7 Additive Modifiers");
                for (Map.Entry<StatSource, Double> sourceEntry : map.getAdditives().entrySet()) {
                    CommandHelper.send(sender, "\u27f6 " + sourceEntry.getKey().getClass().getName() + " " + String.valueOf(sourceEntry.getValue()));
                }
            }
            if (!map.getAdditiveMultipliers().isEmpty()) {
                CommandHelper.send(sender, "\u00b7 Additive Multiplier Modifiers");
                for (Map.Entry<StatSource, Double> sourceEntry : map.getAdditiveMultipliers().entrySet()) {
                    CommandHelper.send(sender, "\u27f6 " + sourceEntry.getKey().getClass().getName() + " " + String.valueOf(sourceEntry.getValue()));
                }
            }
            if (!map.getCompoundMultipliers().isEmpty()) {
                CommandHelper.send(sender, "\u00b7 Compound Multiplier Modifiers");
                for (Map.Entry<StatSource, Double> sourceEntry : map.getCompoundMultipliers().entrySet()) {
                    CommandHelper.send(sender, "\u27f6 " + sourceEntry.getKey().getClass().getName() + " " + String.valueOf(sourceEntry.getValue()));
                }
            }
            if (map.getSetters().isEmpty()) continue;
            CommandHelper.send(sender, "\u00b7 Setter Modifiers");
            for (Map.Entry<StatSource, Double> sourceEntry : map.getSetters().entrySet()) {
                CommandHelper.send(sender, "\u27f6 " + sourceEntry.getKey().getClass().getName() + " " + String.valueOf(sourceEntry.getValue()));
            }
        }
        CommandHelper.sendFooter(sender);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities.getstats";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "getstats";
    }
}

