/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.utility;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ActiveInfoCommand
extends Command<MythicBukkit> {
    public ActiveInfoCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Entity l = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
        if (l == null) {
            CommandHelper.sendError(sender, "You must target a valid entity!");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Information About Entity: " + String.valueOf(l.getUniqueId()));
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "EntityID: " + String.valueOf(ChatColor.GRAY) + l.getEntityId());
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "UUID: " + String.valueOf(ChatColor.GRAY) + String.valueOf(l.getUniqueId()));
        if (MythicBukkit.inst().getMobManager().isActiveMob(l.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Is Active MythicMob: " + String.valueOf(ChatColor.GRAY) + "TRUE");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Is Active MythicMob: " + String.valueOf(ChatColor.GRAY) + "FALSE");
        }
        if (MythicBukkit.inst().getMobManager().isIgnoredEntity(l.getUniqueId())) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Is In Void List: " + String.valueOf(ChatColor.GRAY) + "TRUE");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Is In Void List: " + String.valueOf(ChatColor.GRAY) + "FALSE");
        }
        if (MythicBukkit.inst().getMobManager().isActiveMob(l.getUniqueId())) {
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(l);
            am.remountSpawner();
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "EntityType: " + String.valueOf(ChatColor.GRAY) + String.valueOf((Object)am.getType().getEntityType()));
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "MythicType: " + String.valueOf(ChatColor.GRAY) + am.getType().getInternalName());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Location: " + String.valueOf(ChatColor.GRAY) + am.getLocation().toString());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Level: " + String.valueOf(ChatColor.GRAY) + am.getLevel());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "TypeHealth: " + String.valueOf(ChatColor.GRAY) + am.getType().getHealth(am));
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "+LevelHealth: " + String.valueOf(ChatColor.GRAY) + am.getType().getPerLevelHealth());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "TargetHealth: " + String.valueOf(ChatColor.GRAY) + am.getEntity().getHealth());
            if (am.getType().getDamage() != null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "TypeDamage: " + String.valueOf(ChatColor.GRAY) + am.getType().getDamage().toString());
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "TargetDamage: " + String.valueOf(ChatColor.GRAY) + am.getDamage());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "+LevelPower: " + String.valueOf(ChatColor.GRAY) + am.getType().getPerLevelPower());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "TargetPower: " + String.valueOf(ChatColor.GRAY) + am.getPower());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Current Stance: " + String.valueOf(ChatColor.GRAY) + am.getStance());
            if (am.getSpawner() != null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "FromSpawner: " + String.valueOf(ChatColor.AQUA) + am.getSpawner().getInternalName());
            }
            if (am.getOwnerUUID().isPresent()) {
                Player player = Bukkit.getPlayer((UUID)am.getOwnerUUID().get());
                if (player == null) {
                    sender.sendMessage(ColorString.get("&6Owner: &f" + am.getOwnerUUID().get().toString()));
                } else {
                    sender.sendMessage(ColorString.get("&6Owner: &f" + player.getName()));
                }
            }
            if (am.getParentUUID().isPresent()) {
                if (am.getParent().isPresent()) {
                    AbstractEntity ent = am.getParent().get();
                    if (ent.isPlayer()) {
                        sender.sendMessage(ColorString.get("&6Parent: &f" + ((Player)ent.getBukkitEntity()).getName()));
                    } else {
                        sender.sendMessage(ColorString.get("&6Parent: &a" + String.valueOf(ent.getUniqueId())));
                    }
                } else {
                    sender.sendMessage(ColorString.get("&6Parent: &e" + String.valueOf(am.getParentUUID().get())));
                }
            }
            if (am.getFaction() != null) {
                sender.sendMessage(ColorString.get("&6Faction&7: " + am.getFaction()));
            }
            sender.sendMessage(ColorString.get("&6Has Gravity&7: &f" + (l.hasGravity() ? "TRUE" : "FALSE")));
            if (l instanceof LivingEntity) {
                sender.sendMessage(ColorString.get("&6Has AI&7: &f" + (((LivingEntity)l).hasAI() ? "TRUE" : "FALSE")));
                sender.sendMessage(ColorString.get("&6Is Leashed&7: &f" + (((LivingEntity)l).isLeashed() ? "TRUE" : "FALSE")));
            }
            if (am.isDead()) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Marked as Dead: " + String.valueOf(ChatColor.GRAY) + "TRUE");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Marked as Dead: " + String.valueOf(ChatColor.GRAY) + "FALSE");
            }
            if (am.getEntity().isValid()) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Marked as Valid: " + String.valueOf(ChatColor.GRAY) + "TRUE");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Marked as Valid: " + String.valueOf(ChatColor.GRAY) + "FALSE");
            }
            if (am.hasThreatTable()) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Using ThreatTable: " + String.valueOf(ChatColor.GRAY) + "TRUE");
                if (am.getThreatTable().inCombat()) {
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Top Threat Target: " + String.valueOf(ChatColor.GRAY) + am.getThreatTable().getTopThreatHolder().getName() + " (" + am.getThreatTable().getTopTargetThreat() + ")");
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Total Threat: " + String.valueOf(ChatColor.GRAY) + am.getThreatTable().getTotalThreat());
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "-- Threat Targets: ");
                    for (AbstractEntity le : am.getThreatTable().getAllThreatTargets()) {
                        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "* " + le.getName() + " (" + am.getThreatTable().getThreat(le) + ")");
                    }
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "-- Mob Not In Combat");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Using ThreatTable: " + String.valueOf(ChatColor.GRAY) + "FALSE");
            }
        } else {
            sender.sendMessage(ColorString.get("&6EntityType&7: &f" + l.getType().toString()));
            sender.sendMessage(ColorString.get("&6Location&7: &f" + l.getLocation().toString()));
            if (l instanceof LivingEntity) {
                sender.sendMessage(ColorString.get("&6Health&7: &f" + ((LivingEntity)l).getHealth()));
                sender.sendMessage(ColorString.get("&6MaxHealth&7: &f" + ((LivingEntity)l).getMaxHealth()));
            }
            if (l instanceof Player) {
                Player lp = (Player)l;
                sender.sendMessage(ColorString.get("&6Food&7: &f" + lp.getFoodLevel()));
                sender.sendMessage(ColorString.get("&6Saturation&7: &f" + lp.getSaturation()));
                sender.sendMessage(ColorString.get("&6Is Flying&7: &f" + (lp.isFlying() ? "TRUE" : "FALSE")));
                sender.sendMessage(ColorString.get("&6Is Gliding&7: &f" + (lp.isGliding() ? "TRUE" : "FALSE")));
            }
            if (l instanceof LivingEntity) {
                sender.sendMessage(ColorString.get("&6Has AI&7: &f" + (((LivingEntity)l).hasAI() ? "TRUE" : "FALSE")));
                sender.sendMessage(ColorString.get("&6Is Leashed&7: &f" + (((LivingEntity)l).isLeashed() ? "TRUE" : "FALSE")));
            }
            sender.sendMessage(ColorString.get("&6Has Gravity&7: &f" + (l.hasGravity() ? "TRUE" : "FALSE")));
            sender.sendMessage(ColorString.get("&6Marked as Dead&7: &f" + (l.isDead() ? "TRUE" : "FALSE")));
            sender.sendMessage(ColorString.get("&6Marked as Valid&7: &f" + (l.isValid() ? "TRUE" : "FALSE")));
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.utilities.gettargetinfo";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "activeinfo";
    }
}

