/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.mobs;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class InfoCommand
extends Command<MythicBukkit> {
    public InfoCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            CommandHelper.sendError(sender, "Usage /mm m[obs] i[nfo] <internal-name>");
            return true;
        }
        if (((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(args[0]).isPresent()) {
            MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(args[0]).orElseGet(() -> null);
            sender.sendMessage(ColorString.get("&e&lInformation for &a" + mm4.getInternalName() + "&7:"));
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Mob ID: " + String.valueOf(ChatColor.GRAY) + mm4.hashCode());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Display Name: " + String.valueOf(ChatColor.GRAY) + String.valueOf(mm4.getDisplayName()));
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "EntityType: " + String.valueOf(ChatColor.GRAY) + String.valueOf((Object)mm4.getEntityType()));
            if (mm4.getDamage() != null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Damage: " + String.valueOf(ChatColor.GRAY) + mm4.getDamage().toString() + " (+" + mm4.getPerLevelDamage() + " per level)");
            }
            if (mm4.getHealth() != null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Health: " + String.valueOf(ChatColor.GRAY) + String.valueOf(mm4.getHealth()) + " (+" + mm4.getPerLevelHealth() + " per level)");
            }
            if (mm4.getArmor() != null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Armor: " + String.valueOf(ChatColor.GRAY) + mm4.getArmor().toString() + " (+" + mm4.getPerLevelArmor() + " per level)");
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Power per Level: +" + String.valueOf(ChatColor.GRAY) + mm4.getPerLevelPower());
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Located in File: " + String.valueOf(ChatColor.GRAY) + String.valueOf(mm4.getFile()));
        } else {
            CommandHelper.sendError(sender, "No Mythic Mob loaded with the name " + args[0]);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return CollectionUtils.filterMatches(args[0], ((MythicBukkit)this.getPlugin()).getMobManager().getMobNames(), 2);
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.info";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"i"};
    }
}

