/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters.item;

import com.pg85.otg.shaded.org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.items.components.AbstractItemAttackRangeComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlockStateComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlocksAttacksComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemEquippableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemFoodComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemGliderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemRepairableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemToolComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTooltipComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemUseCooldownComponent;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.uuid.DashedUUIDs;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.jnbt.ByteTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTagBuilder;
import io.lumine.mythic.core.utils.jnbt.IntArrayTag;
import io.lumine.mythic.core.utils.jnbt.IntTag;
import io.lumine.mythic.core.utils.jnbt.ListTag;
import io.lumine.mythic.core.utils.jnbt.ListTagBuilder;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NbtBukkitItemStack
extends BukkitItemStack {
    public NbtBukkitItemStack(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    public NbtBukkitItemStack editMeta(Consumer<ItemMeta> block) {
        ItemMeta meta = this.itemStack.getItemMeta();
        block.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    private NbtBukkitItemStack editTag(String key, Consumer<CompoundTagBuilder> builder) {
        CompoundTag nbt = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(this.itemStack);
        CompoundTag tag = nbt.containsKey(key) ? nbt.getCompound(key) : CompoundTagBuilder.create().build();
        CompoundTagBuilder tagBuilder = tag.createBuilder();
        builder.accept(tagBuilder);
        return this.customData(key, tagBuilder.build());
    }

    @Override
    public NbtBukkitItemStack setName(String name) {
        return this.name(Text.parse(name));
    }

    @Override
    public NbtBukkitItemStack name(Component component) {
        return this.editTag("display", builder -> builder.putString("Name", (String)GsonComponentSerializer.gson().serialize(component)));
    }

    @Override
    public NbtBukkitItemStack setLore(List<String> lines) {
        return this.lore((List)lines.stream().map(Text::parse).toList());
    }

    @Override
    public NbtBukkitItemStack lore(List<Component> lines) {
        return this.editTag("display", builder -> builder.put("Lore", ListTagBuilder.createWith((Tag[])((StringTag[])lines.stream().map(arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).serialize(arg_0)).map(StringTag::new).toArray(StringTag[]::new))).build()));
    }

    @Override
    public NbtBukkitItemStack amount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @Override
    @Deprecated
    public NbtBukkitItemStack data(int data) {
        this.itemStack.setDurability((short)data);
        return this;
    }

    @Override
    public NbtBukkitItemStack breakable(boolean breakable) {
        if (!breakable) {
            return this.customData("Unbreakable", new ByteTag(1));
        }
        return this;
    }

    @Override
    public NbtBukkitItemStack hideAll() {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20)) {
            return this.customData("HideFlags", new IntTag(255));
        }
        return this.customData("HideFlags", new IntTag(127));
    }

    @Override
    public NbtBukkitItemStack flags(Collection<AbstractItemFlag> flags) {
        this.editMeta(meta -> meta.addItemFlags((ItemFlag[])flags.stream().map(BukkitAdapter::adapt).toArray(ItemFlag[]::new)));
        return this;
    }

    @Override
    public NbtBukkitItemStack repairCost(int repairCost) {
        return this.customData("RepairCost", new IntTag(repairCost));
    }

    @Override
    public NbtBukkitItemStack maxStackSize(int maxStackSize) {
        if (maxStackSize == 1) {
            return this.customData("UUID", new IntArrayTag(DashedUUIDs.uuidToIntArray(UUID.randomUUID())));
        }
        return this;
    }

    @Override
    public NbtBukkitItemStack modelData(int modelData) {
        return this.customData("CustomModelData", new IntTag(modelData));
    }

    @Override
    public NbtBukkitItemStack addAttributeModifier(AbstractAttributeModifier modifier) {
        Attribute attribute = (Attribute)Registry.ATTRIBUTE.get(modifier.key());
        if (attribute == null) {
            throw new IllegalArgumentException("Unknown attribute '" + String.valueOf(modifier.key()) + "'");
        }
        UUID uniqueId = UUID.randomUUID();
        EquipSlot abstractSlot = modifier.slot();
        if (abstractSlot == null || abstractSlot == EquipSlot.NONE) {
            return this.editMeta(meta -> meta.addAttributeModifier(attribute, new AttributeModifier(uniqueId, uniqueId.toString(), modifier.value().get(), AttributeModifier.Operation.values()[modifier.operation().getOperation()])));
        }
        EquipmentSlot slot = modifier.slot().getBukkitSlot();
        if (slot == null) {
            throw new IllegalStateException("Unexpected value: " + String.valueOf(modifier.slot()));
        }
        return this.editMeta(meta -> meta.addAttributeModifier(attribute, new AttributeModifier(uniqueId, uniqueId.toString(), modifier.value().get(), AttributeModifier.Operation.values()[modifier.operation().getOperation()], slot)));
    }

    @Override
    public NbtBukkitItemStack enchant(Enchantment enchantment, int level) {
        if (this.itemStack.getType() != Material.ENCHANTED_BOOK) {
            this.itemStack.addUnsafeEnchantment(enchantment, level);
        } else {
            this.editMeta(m4 -> ((EnchantmentStorageMeta)m4).addStoredEnchant(enchantment, level, true));
        }
        return this;
    }

    @Override
    public BukkitItemStack removeEnchant(Enchantment enchantment) {
        if (this.itemStack.getType() != Material.ENCHANTED_BOOK) {
            this.itemStack.removeEnchantment(enchantment);
        } else {
            this.editMeta(m4 -> ((EnchantmentStorageMeta)m4).removeStoredEnchant(enchantment));
        }
        return this;
    }

    @Override
    public NbtBukkitItemStack enchantmentGlow(boolean glow) {
        return glow ? this.enchant(Enchantment.VANISHING_CURSE, 1) : this;
    }

    @Override
    public NbtBukkitItemStack durability(int durability) {
        return this.customData("MYTHIC_CURRENT_CUSTOM_DURABILITY", new IntTag(durability));
    }

    @Override
    public NbtBukkitItemStack maxDurability(int durability) {
        return this.customData("MYTHIC_MAX_CUSTOM_DURABILITY", new IntTag(durability));
    }

    @Override
    public NbtBukkitItemStack canPlaceOn(Collection<Material> materials) {
        this.itemStack = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setCanPlaceOn(this.itemStack, materials);
        return this;
    }

    @Override
    public NbtBukkitItemStack canBreak(Collection<Material> materials) {
        this.itemStack = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setCanBreak(this.itemStack, materials);
        return this;
    }

    @Override
    public NbtBukkitItemStack potionEffect(PotionEffectType type, int duration, int amplifier) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)itemMeta;
            meta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
            this.itemStack.setItemMeta((ItemMeta)meta);
        }
        return this;
    }

    @Override
    public NbtBukkitItemStack color(int r, int g2, int b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        Color color = Color.fromRGB((int)r, (int)g2, (int)b);
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(color);
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
            leatherArmorMeta.setColor(color);
        }
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public NbtBukkitItemStack applyFoodComponent(AbstractItemFoodComponent foodData) {
        return this;
    }

    @Override
    public AbstractItemStack applyConsumableComponent(AbstractItemConsumableComponent consumableData) {
        return this;
    }

    @Override
    public NbtBukkitItemStack applyEquippableComponent(AbstractItemEquippableComponent equippableData) {
        return this;
    }

    @Override
    public AbstractItemStack applyUseCooldownComponent(AbstractItemUseCooldownComponent cooldownData) {
        return this;
    }

    @Override
    public NbtBukkitItemStack applyToolComponent(AbstractItemToolComponent toolData) {
        return this;
    }

    @Override
    public NbtBukkitItemStack applyTooltipComponent(AbstractItemTooltipComponent abstractItemTooltipComponent) {
        return this;
    }

    @Override
    public NbtBukkitItemStack applyBlocksAttacksComponent(DropMetadata dropMetadata, AbstractItemBlocksAttacksComponent abstractItemBlocksAttacksComponent) {
        return this;
    }

    @Override
    public NbtBukkitItemStack applyGliderComponent(DropMetadata dropMetadata, AbstractItemGliderComponent abstractItemGliderComponent) {
        return this;
    }

    @Override
    public NbtBukkitItemStack applyRepairableComponent(DropMetadata dropMetadata, AbstractItemRepairableComponent abstractItemRepairableComponent) {
        return this;
    }

    @Override
    public NbtBukkitItemStack customData(String key, Tag value) {
        this.itemStack = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().addNBTData(this.itemStack, key, value);
        return this;
    }

    @Override
    public NbtBukkitItemStack customData(CompoundTag tag) {
        tag.getValue().forEach(this::customData);
        return this;
    }

    @Override
    public NbtBukkitItemStack itemModel(NamespacedKey itemModel) {
        return this;
    }

    @Override
    public NamespacedKey getItemModel() {
        return null;
    }

    @Override
    public boolean isBreakable() {
        return this.getCustomData().getBoolean("Unbreakable");
    }

    @Override
    public int getRepairCost() {
        return this.getCustomData().getInt("RepairCost");
    }

    @Override
    public int getDurability() {
        int durability = this.getCustomData().getInt("MYTHIC_CURRENT_CUSTOM_DURABILITY");
        if (durability < 1) {
            return Optional.ofNullable(this.getItemMeta()).map(meta -> {
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    return damageable.getDamage();
                }
                return 0;
            }).orElse(0);
        }
        return durability;
    }

    @Override
    public int getMaxDurability() {
        int maxDurability = this.getCustomData().getInt("MYTHIC_MAX_CUSTOM_DURABILITY");
        if (maxDurability < 1) {
            maxDurability = this.getType().getMaxDurability();
        }
        return maxDurability;
    }

    @Override
    public CompoundTag getCustomData() {
        return MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(this.itemStack);
    }

    @Override
    public NbtBukkitItemStack copy() {
        return new NbtBukkitItemStack(this.itemStack.clone());
    }

    @Override
    public AbstractItemStack applyBlockStateComponent(DropMetadata dropMetadata, AbstractItemBlockStateComponent component) {
        return this;
    }

    @Override
    public AbstractItemStack applyAttackRangeComponent(DropMetadata dropMetadata, AbstractItemAttackRangeComponent abstractItemAttackRangeComponent) {
        MythicLogger.error("AttackRange Component is only available on Paper 1.21.11+");
        return this;
    }

    private NbtBukkitItemStack skullData(String username, UUID uniqueId, String texture, String url) {
        if (username != null) {
            return this.customData("SkullOwner", new StringTag(username));
        }
        if (texture != null || url != null) {
            CompoundTag valuesTag = CompoundTag.create(data -> data.putString("Value", Objects.requireNonNullElseGet(texture, () -> Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + url + "\"}}}")))));
            ListTag valuesList = ListTagBuilder.createWith((Tag[])new CompoundTag[]{valuesTag}).build();
            return this.customData("SkullOwner", CompoundTag.create(skullOwnerTag -> {
                skullOwnerTag.put("Properties", CompoundTag.create(properties -> properties.put("textures", valuesList)));
                skullOwnerTag.putUUID("Id", uniqueId);
            }));
        }
        return this;
    }
}

