/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters.item;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractAttributeModifier;
import io.lumine.mythic.api.adapters.AbstractItemFlag;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractItemStackRarity;
import io.lumine.mythic.api.adapters.items.components.AbstractItemAttackRangeComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlockStateComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlocksAttacksComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBreakSoundComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBucketEntityDataComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemEnchantableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemEquippableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemFoodComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemGliderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemJukeboxPlayableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemKineticWeaponComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemOminousBottleAmplifierComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPiercingWeaponComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotDecorationsComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemRepairableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemToolComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTooltipComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemUseCooldownComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemUseRemainderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemWeaponComponent;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class ItemComponentBukkitItemStack
extends BukkitItemStack {
    public ItemComponentBukkitItemStack(ItemStack itemStack) {
        super(itemStack);
    }

    public boolean isFireResistant() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::isFireResistant).orElse(false);
    }

    @Nullable
    public AbstractItemStackRarity getRarity() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::getRarity).map(rarity -> switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case ItemRarity.EPIC -> AbstractItemStackRarity.EPIC;
            case ItemRarity.RARE -> AbstractItemStackRarity.RARE;
            case ItemRarity.UNCOMMON -> AbstractItemStackRarity.UNCOMMON;
            case ItemRarity.COMMON -> AbstractItemStackRarity.COMMON;
        }).orElse(null);
    }

    public BukkitItemStack clone() {
        return new ItemComponentBukkitItemStack(this.itemStack.clone());
    }

    @Override
    public ItemComponentBukkitItemStack editMeta(Consumer<ItemMeta> block) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(this.itemStack.getType());
        }
        if (meta == null) {
            return this;
        }
        block.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack setName(String name) {
        return this.name(Text.parse(name));
    }

    @Override
    public ItemComponentBukkitItemStack name(Component component) {
        if (ServerVersion.isPaper()) {
            return this.editMeta(meta -> meta.displayName(component));
        }
        return this.editMeta(meta -> meta.setDisplayName(Text.toLegacy(component)));
    }

    @Override
    public ItemComponentBukkitItemStack setLore(List<String> lore) {
        return this.lore((List)lore.stream().map(Text::parse).toList());
    }

    @Override
    public ItemComponentBukkitItemStack lore(List<Component> lines) {
        if (ServerVersion.isPaper()) {
            return this.editMeta(meta -> meta.lore(lines));
        }
        ArrayList lore = Lists.newArrayList();
        lines.forEach(line -> lore.add(Text.toLegacy(line)));
        return this.editMeta(meta -> meta.setLore(lore));
    }

    @Override
    public ItemComponentBukkitItemStack amount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @Override
    @Deprecated
    public ItemComponentBukkitItemStack data(int data) {
        this.itemStack.setDurability((short)data);
        return this;
    }

    @Override
    public boolean isBreakable() {
        return Optional.ofNullable(this.getItemMeta()).map(ItemMeta::isUnbreakable).orElse(true) == false;
    }

    @Override
    public ItemComponentBukkitItemStack breakable(boolean breakable) {
        return this.editMeta(meta -> meta.setUnbreakable(!breakable));
    }

    @Override
    public ItemComponentBukkitItemStack hideAll() {
        return this.flags(Arrays.asList(AbstractItemFlag.values()));
    }

    @Override
    public ItemComponentBukkitItemStack flags(Collection<AbstractItemFlag> flags) {
        this.editMeta(meta -> meta.addItemFlags((ItemFlag[])flags.stream().map(BukkitAdapter::adapt).toArray(ItemFlag[]::new)));
        return this;
    }

    @Override
    public int getRepairCost() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            if (meta instanceof Repairable) {
                Repairable repairable = (Repairable)meta;
                return repairable.getRepairCost();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack repairCost(int repairCost) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Repairable) {
            Repairable repairable = (Repairable)meta;
            repairable.setRepairCost(repairCost);
            this.itemStack.setItemMeta((ItemMeta)repairable);
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack maxStackSize(int maxStackSize) {
        return this.editMeta(meta -> meta.setMaxStackSize(Integer.valueOf(maxStackSize)));
    }

    @Override
    public ItemComponentBukkitItemStack modelData(int modelData) {
        return this.editMeta(meta -> meta.setCustomModelData(Integer.valueOf(modelData)));
    }

    @Override
    public ItemComponentBukkitItemStack addAttributeModifier(AbstractAttributeModifier modifier) {
        Attribute attribute = (Attribute)Registry.ATTRIBUTE.get(modifier.key());
        if (attribute == null) {
            throw new IllegalArgumentException("Unknown attribute '" + String.valueOf(modifier.key()) + "'");
        }
        UUID uniqueId = modifier.uniqueId();
        EquipSlot abstractSlot = modifier.slot();
        if (abstractSlot == null || abstractSlot == EquipSlot.NONE) {
            return this.editMeta(meta -> meta.addAttributeModifier(attribute, new AttributeModifier(uniqueId, uniqueId.toString(), modifier.value().get(), AttributeModifier.Operation.values()[modifier.operation().getOperation()])));
        }
        EquipmentSlot slot = modifier.slot().getBukkitSlot();
        if (slot == null) {
            throw new IllegalStateException("Unexpected value: " + String.valueOf(modifier.slot()));
        }
        return this.editMeta(meta -> meta.addAttributeModifier(attribute, new AttributeModifier(uniqueId, uniqueId.toString(), modifier.value().get(), AttributeModifier.Operation.values()[modifier.operation().getOperation()], slot)));
    }

    @Override
    public ItemComponentBukkitItemStack enchant(Enchantment enchantment, int level) {
        if (this.itemStack.getType() != Material.ENCHANTED_BOOK) {
            this.itemStack.addUnsafeEnchantment(enchantment, level);
        } else {
            this.editMeta(m4 -> ((EnchantmentStorageMeta)m4).addStoredEnchant(enchantment, level, true));
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack removeEnchant(Enchantment enchantment) {
        if (this.itemStack.getType() != Material.ENCHANTED_BOOK) {
            this.itemStack.removeEnchantment(enchantment);
        } else {
            this.editMeta(m4 -> ((EnchantmentStorageMeta)m4).removeStoredEnchant(enchantment));
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack enchantmentGlow(boolean glow) {
        return this.editMeta(meta -> meta.setEnchantmentGlintOverride(Boolean.valueOf(glow)));
    }

    @Override
    public int getDurability() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                return damageable.getDamage();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack durability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(durability);
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public int getMaxDurability() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            Damageable damageable;
            if (meta instanceof Damageable && (damageable = (Damageable)meta).hasMaxDamage()) {
                return damageable.getMaxDamage();
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack maxDurability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setMaxDamage(Integer.valueOf(durability));
            this.itemStack.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack canPlaceOn(Collection<Material> materials) {
        this.itemStack = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setCanPlaceOn(this.itemStack, materials);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack canBreak(Collection<Material> materials) {
        this.itemStack = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setCanBreak(this.itemStack, materials);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack potionEffect(PotionEffectType type, int duration, int amplifier) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)itemMeta;
            meta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
            this.itemStack.setItemMeta((ItemMeta)meta);
        }
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack color(int r, int g2, int b) {
        ItemMeta meta = this.itemStack.getItemMeta();
        Color color = Color.fromRGB((int)r, (int)g2, (int)b);
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(color);
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
            leatherArmorMeta.setColor(color);
        }
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack applyFoodComponent(AbstractItemFoodComponent foodData) {
        return this.editMeta(meta -> {
            if (foodData == null) {
                meta.setFood(null);
                return;
            }
            FoodComponent foodComponent = meta.getFood();
            if (foodData.getCanAlwaysEat() != null) {
                foodComponent.setCanAlwaysEat(foodData.getCanAlwaysEat().booleanValue());
            }
            if (foodData.getNutrition() != null) {
                foodComponent.setNutrition(foodData.getNutrition().intValue());
            }
            if (foodData.getSaturation() != null) {
                foodComponent.setSaturation(foodData.getSaturation().floatValue());
            }
            meta.setFood(foodComponent);
        });
    }

    @Override
    public AbstractItemStack applyConsumableComponent(AbstractItemConsumableComponent consumableData) {
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack applyPotionComponent(DropMetadata dropMetadata, AbstractItemPotionComponent potionData) {
        return this.editMeta(meta -> {
            if (!(meta instanceof PotionMeta)) {
                return;
            }
            PotionMeta potionMeta = (PotionMeta)meta;
            if (potionData.getPotionColor() != null) {
                try {
                    potionMeta.setColor(potionData.getPotionColor().get(dropMetadata).toBukkitColor());
                }
                catch (Exception ex) {
                    MythicLogger.error("Potion color is configured incorrectly");
                }
            }
            if (potionData.getEffects() != null) {
                potionMeta.clearCustomEffects();
                for (BukkitPotionEffect effect : potionData.getEffects()) {
                    potionMeta.addCustomEffect(effect.getEffect(), false);
                }
            }
        });
    }

    @Override
    public ItemComponentBukkitItemStack applyEquippableComponent(AbstractItemEquippableComponent equippableData) {
        if (ServerVersion.isBefore(MinecraftVersions.v1_21_3)) {
            return this;
        }
        return this.editMeta(meta -> {
            if (equippableData == null) {
                meta.setEquippable(null);
                return;
            }
            EquippableComponent equippableComponent = meta.getEquippable();
            if (equippableComponent == null) {
                // empty if block
            }
            if (equippableData.getModel() != null) {
                equippableComponent.setModel(equippableData.getModel());
            }
            if (equippableData.getSlot() != null) {
                equippableComponent.setSlot(equippableData.getSlot());
            }
            if (equippableData.getCameraOverlay() != null) {
                equippableComponent.setCameraOverlay(equippableData.getCameraOverlay());
            }
            if (equippableData.getDispensable() != null) {
                equippableComponent.setDispensable(equippableData.getDispensable().booleanValue());
            }
            if (equippableData.getSwappable() != null) {
                equippableComponent.setSwappable(equippableData.getSwappable().booleanValue());
            }
            if (equippableData.getDamageOnHurt() != null) {
                equippableComponent.setDamageOnHurt(equippableData.getDamageOnHurt().booleanValue());
            }
            if (equippableData.getEquipSound() != null) {
                Object soundKey = equippableData.getEquipSound().toLowerCase(Locale.ROOT);
                if (!((String)soundKey).contains(":")) {
                    soundKey = "minecraft:" + (String)soundKey;
                }
                Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)soundKey));
                equippableComponent.setEquipSound(sound);
            }
            if (equippableData.getEntityTypes() != null && !equippableData.getEntityTypes().isEmpty()) {
                equippableComponent.setAllowedEntities(equippableData.getEntityTypes().stream().map(EntityType::valueOf).toList());
            }
            meta.setEquippable(equippableComponent);
        });
    }

    @Override
    public AbstractItemStack applyUseCooldownComponent(AbstractItemUseCooldownComponent cooldownData) {
        if (ServerVersion.isBefore(MinecraftVersions.v1_21_3)) {
            return this;
        }
        return this.editMeta(meta -> {
            if (cooldownData == null) {
                meta.setUseCooldown(null);
                return;
            }
            UseCooldownComponent useCooldownComponent = meta.getUseCooldown();
            if (cooldownData.getCooldownGroup() != null) {
                useCooldownComponent.setCooldownGroup(cooldownData.getCooldownGroup());
            }
            if (cooldownData.getCooldownSeconds() != null) {
                useCooldownComponent.setCooldownSeconds((float)cooldownData.getCooldownSeconds().intValue());
            }
            meta.setUseCooldown(useCooldownComponent);
        });
    }

    @Override
    public AbstractItemStack applyToolComponent(AbstractItemToolComponent toolData) {
        return this.editMeta(meta -> {
            if (toolData == null) {
                meta.setTool(null);
                return;
            }
            ToolComponent toolComponent = meta.getTool();
            if (toolData.getDamagePerBlock() != null) {
                toolComponent.setDamagePerBlock(toolData.getDamagePerBlock().intValue());
            }
            if (toolData.getDefaultMiningSpeed() != null) {
                toolComponent.setDefaultMiningSpeed(toolData.getDefaultMiningSpeed().floatValue());
            }
            if (!toolData.getRules().isEmpty()) {
                for (AbstractItemToolComponent.AbstractToolRule rule : toolData.getRules()) {
                    if (rule.getMaterials() == null) {
                        toolComponent.addRule(rule.getTag(), rule.getSpeed(), rule.getIsCorrectForBlock());
                        continue;
                    }
                    toolComponent.addRule(rule.getMaterials(), rule.getSpeed(), rule.getIsCorrectForBlock());
                }
            }
            meta.setTool(toolComponent);
        });
    }

    @Override
    public CompoundTag getCustomData() {
        return MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().getNBTData(this.itemStack);
    }

    @Override
    public ItemComponentBukkitItemStack customData(String key, Tag value) {
        this.itemStack = MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().addNBTData(this.itemStack, key, value);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack customData(CompoundTag tag) {
        tag.getValue().forEach(this::customData);
        return this;
    }

    @Override
    public ItemComponentBukkitItemStack itemModel(NamespacedKey itemModel) {
        return this.editMeta(meta -> meta.setItemModel(itemModel));
    }

    @Override
    public NamespacedKey getItemModel() {
        return this.getItemMeta().getItemModel();
    }

    @Override
    public ItemComponentBukkitItemStack copy() {
        return new ItemComponentBukkitItemStack(this.itemStack.clone());
    }

    @Override
    public AbstractItemStack applyBlockStateComponent(DropMetadata dropMetadata, AbstractItemBlockStateComponent component) {
        MythicBukkit.inst().getVolatileCodeHandler().getItemHandler().setItemBlockStateComponent(this.itemStack, component.getStates());
        return this;
    }

    @Override
    public AbstractItemStack applyAttackRangeComponent(DropMetadata dropMetadata, AbstractItemAttackRangeComponent abstractItemAttackRangeComponent) {
        MythicLogger.error("AttackRange Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyEnchantableComponent(DropMetadata dropMetadata, AbstractItemEnchantableComponent componentConfig) {
        MythicLogger.error("Enchantable Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyWeaponComponent(DropMetadata dropMetadata, AbstractItemWeaponComponent componentConfig) {
        MythicLogger.error("Weapon Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyKineticWeaponComponent(DropMetadata dropMetadata, AbstractItemKineticWeaponComponent componentConfig) {
        MythicLogger.error("KineticWeapon Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyUseRemainderComponent(DropMetadata dropMetadata, AbstractItemUseRemainderComponent componentConfig) {
        MythicLogger.error("UseRemainder Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyJukeboxPlayableComponent(DropMetadata dropMetadata, AbstractItemJukeboxPlayableComponent componentConfig) {
        MythicLogger.error("JukeboxPlayable Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyBreakSoundComponent(DropMetadata dropMetadata, AbstractItemBreakSoundComponent componentConfig) {
        MythicLogger.error("BreakSound Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyPotDecorationsComponent(DropMetadata dropMetadata, AbstractItemPotDecorationsComponent componentConfig) {
        MythicLogger.error("PotDecorations Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyOminousBottleAmplifierComponent(DropMetadata dropMetadata, AbstractItemOminousBottleAmplifierComponent componentConfig) {
        MythicLogger.error("OminousBottleAmplifier Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyBucketEntityDataComponent(DropMetadata dropMetadata, AbstractItemBucketEntityDataComponent componentConfig) {
        MythicLogger.error("BucketEntityData Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyPiercingWeaponComponent(DropMetadata dropMetadata, AbstractItemPiercingWeaponComponent componentConfig) {
        MythicLogger.error("PiercingWeapon Component is only available on Paper");
        return this;
    }

    public ItemComponentBukkitItemStack fireResistant(boolean fireResistant) {
        return this.editMeta(meta -> meta.setFireResistant(fireResistant));
    }

    public ItemComponentBukkitItemStack rarity(AbstractItemStackRarity rarity) {
        return this.editMeta(meta -> meta.setRarity(switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractItemStackRarity.COMMON -> ItemRarity.COMMON;
            case AbstractItemStackRarity.UNCOMMON -> ItemRarity.UNCOMMON;
            case AbstractItemStackRarity.RARE -> ItemRarity.RARE;
            case AbstractItemStackRarity.EPIC -> ItemRarity.EPIC;
        }));
    }

    @Override
    public AbstractItemStack applyTooltipComponent(AbstractItemTooltipComponent abstractItemTooltipComponent) {
        MythicLogger.error("ToolTip Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyBlocksAttacksComponent(DropMetadata dropMetadata, AbstractItemBlocksAttacksComponent abstractItemBlocksAttacksComponent) {
        MythicLogger.error("BlocksAttacks Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyGliderComponent(DropMetadata dropMetadata, AbstractItemGliderComponent abstractItemGliderComponent) {
        MythicLogger.error("Glider Component is only available on Paper");
        return this;
    }

    @Override
    public AbstractItemStack applyRepairableComponent(DropMetadata dropMetadata, AbstractItemRepairableComponent abstractItemRepairableComponent) {
        MythicLogger.error("Repairable Component is only available on Paper");
        return this;
    }
}

