/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class BukkitItemMatcher
extends AbstractItemMatcher {
    private final Collection<Material> materials = Sets.newHashSet();
    private final Collection<AbstractItemStack> specificItems = Sets.newHashSet();
    private final Collection<Tag<Material>> tags = Sets.newHashSet();
    private boolean strict = false;
    private boolean vanillaOnly = false;
    private boolean inverted = false;

    public BukkitItemMatcher(MythicLineConfig config, String conditionVar) {
        this.strict = config.getBoolean(new String[]{"strict", "exact", "e"}, false);
        this.vanillaOnly = config.getBoolean(new String[]{"vanillaonly", "vanilla"}, false);
        this.inverted = config.getBoolean(new String[]{"inverted", "blacklist", "bl"}, false);
        MythicBukkit.inst().getClock().queuePostReload(() -> {
            List<String> list = config.getStringList(new String[]{"types", "type", "t", "material", "mat", "m", "item", "i"}, null, conditionVar);
            if (list != null) {
                for (String line : list) {
                    this.parse(line);
                }
            }
        });
    }

    public BukkitItemMatcher(String filter, boolean strict) {
        String[] split;
        for (String line : split = filter.split(",")) {
            this.parse(line);
        }
    }

    public BukkitItemMatcher(Collection<String> filter, boolean strict) {
        for (String line : filter) {
            this.parse(line);
        }
    }

    private void parse(String filter) {
        if (filter.startsWith("#")) {
            NamespacedKey key;
            Tag tag;
            Object raw = filter.substring(1).toLowerCase(Locale.ROOT);
            if (!((String)raw).contains(":")) {
                raw = "minecraft:" + (String)raw;
            }
            if ((tag = Bukkit.getTag((String)"items", (NamespacedKey)(key = NamespacedKey.fromString((String)raw)), Material.class)) == null) {
                MythicLogger.error("[ItemType] ItemTag '#" + String.valueOf(key) + "' does not exist");
            } else {
                this.tags.add((Tag<Material>)tag);
            }
            return;
        }
        if (filter.contains("*")) {
            String regex = "^" + filter.replace("*", ".*") + "$";
            Pattern pattern = Pattern.compile(regex, 2);
            for (Material m4 : Material.values()) {
                if (!m4.isItem() || !pattern.matcher(m4.name()).matches()) continue;
                this.materials.add(m4);
            }
            for (MythicItem item : MythicBukkit.inst().getItemManager().getItems()) {
                if (!pattern.matcher(item.getInternalName()).matches()) continue;
                this.specificItems.add(item.generateItemStack(1));
            }
            return;
        }
        String name = filter.contains(":") ? filter.substring(filter.indexOf(58) + 1) : filter;
        Material mat = Material.getMaterial((String)name.toUpperCase(Locale.ROOT));
        if (mat != null) {
            this.materials.add(mat);
            return;
        }
        AbstractItemStack custom = MythicBukkit.inst().getBootstrap().createItem(filter);
        if (custom != null) {
            this.specificItems.add(custom);
        } else {
            MythicLogger.error("[ItemType] filter \u201c" + filter + "\u201d did not match any material or custom item");
        }
    }

    @Override
    public boolean matches(AbstractItemStack stack) {
        if (!(stack instanceof BukkitItemStack)) {
            return false;
        }
        BukkitItemStack bukkitItemStack = (BukkitItemStack)stack;
        if (this.vanillaOnly && bukkitItemStack.getMythicItemType().isPresent()) {
            return false;
        }
        if (!this.materials.isEmpty() && (!this.strict || bukkitItemStack.getMythicItemType().isEmpty()) && this.materials.contains(bukkitItemStack.getItemStack().getType())) {
            return true;
        }
        if (!this.specificItems.isEmpty()) {
            for (AbstractItemStack item : this.specificItems) {
                if (!item.isSimilar(stack)) continue;
                return true;
            }
        }
        if (!this.tags.isEmpty()) {
            Material material = bukkitItemStack.getItemStack().getType();
            for (Tag<Material> tag : this.tags) {
                Log.info("[ItemMatcher] Check tag {0}", tag.getKey().toString());
                if (!tag.isTagged((Keyed)material)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(ItemStack stack) {
        Material material = stack.getType();
        BukkitItemStack bukkitItemStack = BukkitAdapter.adapt(stack);
        if (this.vanillaOnly && bukkitItemStack.getMythicItemType().isPresent()) {
            return false;
        }
        if (!this.materials.isEmpty() && this.materials.contains(material)) {
            return true;
        }
        if (!this.tags.isEmpty()) {
            for (Tag<Material> tag : this.tags) {
                if (!tag.isTagged((Keyed)material)) continue;
                return true;
            }
        }
        return !this.specificItems.isEmpty() && this.specificItems.contains(bukkitItemStack);
    }

    @Override
    public boolean matches(SkillMetadata skillMetadata) {
        Optional<Object> maybeItem = skillMetadata.getMetadata("item");
        if (maybeItem.isPresent()) {
            ItemStack itemStack = (ItemStack)maybeItem.get();
            BukkitItemStack aItemStack = BukkitAdapter.adapt(itemStack);
            return this.matches(aItemStack);
        }
        if (skillMetadata.getVariables().has("equip-item")) {
            ItemStack itemStack = (ItemStack)skillMetadata.getVariables().get("equip-item").get();
            BukkitItemStack aItemStack = BukkitAdapter.adapt(itemStack);
            return this.matches(aItemStack);
        }
        return false;
    }

    @Override
    public boolean matches(AbstractEntity entity) {
        Entity bukkitEntity = entity.getBukkitEntity();
        if (!(bukkitEntity instanceof Item)) {
            return false;
        }
        Item item = (Item)bukkitEntity;
        ItemStack itemStack = item.getItemStack();
        return this.matches(BukkitAdapter.adapt(itemStack));
    }

    public Collection<Material> getMaterials() {
        return this.materials;
    }

    public Collection<AbstractItemStack> getSpecificItems() {
        return this.specificItems;
    }

    public Collection<Tag<Material>> getTags() {
        return this.tags;
    }
}

