/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractBlockMatcher;
import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.adapters.AbstractEnchantment;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractFirework;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractPotionEffect;
import io.lumine.mythic.api.adapters.AbstractTeleportData;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.adapters.ServerInterface;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemDeathProtectionComponent;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.BukkitEntityLookup;
import io.lumine.mythic.bukkit.BukkitPlatformBridge;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.adapters.BukkitBlockMatcher;
import io.lumine.mythic.bukkit.adapters.BukkitEnchantment;
import io.lumine.mythic.bukkit.adapters.BukkitFirework;
import io.lumine.mythic.bukkit.adapters.BukkitItemMatcher;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.adapters.BukkitWorld;
import io.lumine.mythic.bukkit.adapters.attributes.BukkitAttributable;
import io.lumine.mythic.bukkit.adapters.bossbars.AdventureBossBar;
import io.lumine.mythic.bukkit.adapters.item.NbtBukkitItemStack;
import io.lumine.mythic.bukkit.entities.BukkitBabyPigZombie;
import io.lumine.mythic.bukkit.entities.BukkitBabyPigZombieVillager;
import io.lumine.mythic.bukkit.entities.BukkitBabyPiglin;
import io.lumine.mythic.bukkit.entities.BukkitBabyZombie;
import io.lumine.mythic.bukkit.entities.BukkitBabyZombieVillager;
import io.lumine.mythic.bukkit.entities.BukkitPigZombie;
import io.lumine.mythic.bukkit.entities.BukkitPigZombieVillager;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.listeners.ChunkListeners;
import io.lumine.mythic.bukkit.listeners.EggListeners;
import io.lumine.mythic.bukkit.listeners.MobListeners;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.InvalidDrop;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.DropTableDrop;
import io.lumine.mythic.core.drops.droppables.VanillaItemDrop;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.items.RandomTableItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BukkitBootstrap
extends ReloadableModule<MythicBukkit>
implements ServerInterface {
    private BukkitPlatformBridge platformBridge;
    private BukkitEntityLookup entityLookup;
    private MobListeners mobListeners;
    private ChunkListeners chunkListeners;
    private EggListeners eggListeners;
    private Map<EntityType, MythicEntityType> typeMap;

    public BukkitBootstrap(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.entityLookup = new BukkitEntityLookup(plugin);
        this.mobListeners = new MobListeners(plugin);
        this.bind(this.mobListeners);
        this.chunkListeners = new ChunkListeners(plugin);
        this.bind(this.chunkListeners);
        this.eggListeners = new EggListeners(plugin);
        this.bind(this.eggListeners);
        try {
            if (ServerVersion.isPaper()) {
                Class<?> clazz = Class.forName("io.lumine.mythic.paper.PaperPlatformBridge");
                this.platformBridge = (BukkitPlatformBridge)clazz.getConstructor(BukkitBootstrap.class).newInstance(this);
            } else {
                Class<?> clazz = Class.forName("io.lumine.mythic.spigot.SpigotPlatformBridge");
                this.platformBridge = (BukkitPlatformBridge)clazz.getConstructor(BukkitBootstrap.class).newInstance(this);
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.typeMap = Maps.newEnumMap(EntityType.class);
        for (EntityType type2 : EntityType.values()) {
            MythicEntityType mythicType = MythicEntityType.get(type2.toString());
            if (mythicType == null) continue;
            this.typeMap.put(type2, mythicType);
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_4)) {
            this.typeMap.forEach((type, met) -> {
                if (type == EntityType.UNKNOWN) {
                    return;
                }
                if (((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().hasDefaultAttributes((EntityType)type)) {
                    BukkitAttributable attributable = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().getDefaultAttributes((EntityType)type);
                    met.initializeDefaultValues(attributable);
                }
            });
        } else {
            Schedulers.sync().runLater(this::initializeMagicEntityValues, 1L);
        }
    }

    @Override
    public void unload() {
    }

    public BukkitItemStack wrapItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            return this.platformBridge.wrapItem(item);
        }
        return new NbtBukkitItemStack(item);
    }

    @Override
    public List<AbstractWorld> getWorlds() {
        ArrayList<AbstractWorld> wl = new ArrayList<AbstractWorld>();
        for (World w : Bukkit.getWorlds()) {
            wl.add(new BukkitWorld(w));
        }
        return wl;
    }

    @Override
    public void dispatchCommand(String s2) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), s2);
    }

    @Override
    public AbstractPlayer getPlayer(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return BukkitAdapter.adapt(player);
    }

    @Override
    public AbstractPlayer getPlayer(String name) {
        Player player = Bukkit.getPlayerExact((String)name);
        if (player == null) {
            return null;
        }
        return BukkitAdapter.adapt(player);
    }

    @Override
    public MythicEntityType getMythicEntityType(EntityType type) {
        return this.typeMap.get(type);
    }

    @Override
    public AbstractEntity getEntity(UUID uuid) {
        return this.entityLookup.getEntity(uuid);
    }

    @Override
    public Collection<AbstractEntity> getEntities(AbstractWorld world) {
        if (Bukkit.isPrimaryThread()) {
            ArrayList ret = Lists.newArrayList();
            World bukkitWorld = BukkitAdapter.adapt(world);
            for (Entity entity : bukkitWorld.getEntities()) {
                ret.add(BukkitAdapter.adapt(entity));
            }
            return ret;
        }
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntities(world);
    }

    @Override
    public Collection<AbstractEntity> getLivingEntities(AbstractWorld world) {
        if (Bukkit.isPrimaryThread()) {
            ArrayList ret = Lists.newArrayList();
            World bukkitWorld = BukkitAdapter.adapt(world);
            for (LivingEntity entity : bukkitWorld.getLivingEntities()) {
                ret.add(BukkitAdapter.adapt((Entity)entity));
            }
            return ret;
        }
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getLivingEntities(world);
    }

    @Override
    public Collection<AbstractPlayer> getPlayers(AbstractWorld world) {
        if (Bukkit.isPrimaryThread()) {
            ArrayList ret = Lists.newArrayList();
            World bukkitWorld = BukkitAdapter.adapt(world);
            for (Player entity : bukkitWorld.getPlayers()) {
                ret.add(BukkitAdapter.adapt(entity));
            }
            return ret;
        }
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getPlayers(world);
    }

    @Override
    public Collection<AbstractEntity> getEntities(Collection<UUID> uuids) {
        return this.entityLookup.getEntities(uuids);
    }

    @Override
    public AbstractWorld getWorld(UUID uuid) {
        World world = Bukkit.getWorld((UUID)uuid);
        if (world == null) {
            return null;
        }
        return BukkitAdapter.adapt(world);
    }

    @Override
    public AbstractWorld getWorld(String name) {
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            return null;
        }
        return new BukkitWorld(world);
    }

    @Override
    public AbstractBiome getBiome(String biome) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getBiome(biome).orElseGet(null);
    }

    @Override
    public AbstractBiome getBiome(AbstractLocation location) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getBiome(location);
    }

    @Override
    public Collection<AbstractBiome> getBiomes(String biomeSearch) {
        ArrayList biomes = Lists.newArrayList();
        if (!((String)biomeSearch).contains(":") && !((String)biomeSearch).startsWith("*")) {
            biomeSearch = "minecraft:" + (String)biomeSearch;
        }
        for (AbstractBiome biome : ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getBiomes()) {
            if (!biome.matches((String)biomeSearch)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public AbstractBlock getBlock(String name) {
        String nameUpper = name.toUpperCase(Locale.ROOT);
        if (nameUpper.startsWith("MMOITEMS")) {
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getMMOItems().isEmpty()) {
                return new AbstractBlock.InvalidBlock();
            }
            String type = name.substring(9);
            int id = Integer.parseInt(type);
            return ((MythicBukkit)this.getPlugin()).getCompatibility().getMMOItems().get().getCustomMMOBlock(id);
        }
        try {
            BlockData blockData = Bukkit.createBlockData((String)name.toLowerCase());
            return new BukkitBlock(blockData);
        }
        catch (Error | Exception throwable) {
            if (((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().isPresent() && ((MythicBukkit)this.getPlugin()).getItemManager().getItem(name).isPresent()) {
                return ((MythicBukkit)this.getPlugin()).getCompatibility().getCrucible().get().getCustomBlock(name);
            }
            return new AbstractBlock.InvalidBlock();
        }
    }

    @Override
    public AbstractBlock getBlock(AbstractLocation location) {
        return new BukkitBlock(BukkitAdapter.adapt(location).getBlock().getBlockData());
    }

    @Override
    public AbstractBlockMatcher getBlockMatcher(String name) {
        return new BukkitBlockMatcher(name);
    }

    @Override
    public AbstractBlockMatcher getBlockMatcher(Collection<String> name) {
        return new BukkitBlockMatcher(name);
    }

    @Override
    public List<AbstractPlayer> getOnlinePlayers() {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public int getOnlinePlayerCount() {
        return Bukkit.getServer().getOnlinePlayers().size();
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public AbstractLocation newLocation(AbstractWorld w, double x, double y, double z, float yaw, float pitch) {
        Location l = new Location(BukkitAdapter.adapt(w), x, y, z, yaw, pitch);
        return BukkitAdapter.adapt(l);
    }

    @Override
    public boolean isValidBiome(Object o) {
        return false;
    }

    @Override
    public AbstractBossBar createBossBar(String title, AbstractBossBar.BarColor color, AbstractBossBar.BarStyle style) {
        return new AdventureBossBar(title, 1.0f, color, style);
    }

    @Override
    public AbstractItemStack createItem(String type) {
        if (((MythicBukkit)this.plugin).getCompatibility().getMMOItems().isPresent() && type.toLowerCase(Locale.ROOT).startsWith("mmoitems.")) {
            return BukkitAdapter.adapt(((MythicBukkit)this.plugin).getCompatibility().getMMOItems().get().getCustomItem(type.substring(9)));
        }
        Optional<MythicItem> mythicItem = ((MythicBukkit)this.plugin).getItemManager().getItem(type);
        if (mythicItem.isPresent()) {
            return mythicItem.get().generateItemStack(1);
        }
        Material material = Material.matchMaterial((String)type.toUpperCase(Locale.ROOT));
        if (material != null) {
            return BukkitAdapter.adapt(material);
        }
        IDrop drop = ((MythicBukkit)this.plugin).getDropManager().getDrop("", type);
        if (drop == null || drop instanceof InvalidDrop) {
            throw new IllegalArgumentException("Could not adapt item stack of unknown drop type '" + type + "'");
        }
        if (drop instanceof CustomDrop) {
            CustomDrop customDrop = (CustomDrop)drop;
            if (customDrop.getDrop().isEmpty()) {
                throw new IllegalArgumentException("Could not adapt item stack of invalid custom drop type '" + type + "'");
            }
            drop = customDrop.getDrop().get();
        }
        if (drop instanceof VanillaItemDrop) {
            VanillaItemDrop vanillaItemDrop = (VanillaItemDrop)drop;
            return vanillaItemDrop.getDrop(new DropMetadataImpl(null, null), 1.0);
        }
        if (drop instanceof DropTableDrop) {
            DropTableDrop dropTableDrop = (DropTableDrop)drop;
            return new RandomTableItem(dropTableDrop.getDropTable());
        }
        throw new IllegalArgumentException("Could not adapt item stack of unknown or invalid type '" + type + "'");
    }

    @Override
    public AbstractItemMatcher getItemMatcher(MythicLineConfig config, String conditionVar) {
        return new BukkitItemMatcher(config, conditionVar);
    }

    @Override
    public AbstractItemMatcher getItemMatcher(String type, boolean strict) {
        return new BukkitItemMatcher(type, strict);
    }

    @Override
    public AbstractItemMatcher getItemMatcher(Collection<String> types, boolean strict) {
        return new BukkitItemMatcher(types, strict);
    }

    @Override
    public AbstractEnchantment createEnchantment(String enchantmentName) {
        return new BukkitEnchantment(enchantmentName);
    }

    @Override
    public AbstractPotionEffect createPotionEffect(String effectType, int duration, int level, boolean ambient, boolean particles, boolean icon) {
        return new BukkitPotionEffect(effectType, duration, level, ambient, particles, icon);
    }

    @Override
    public MythicEntityType getMythicEntityType(Entity e) {
        String type;
        switch (type = e.getType().toString()) {
            case "PIG_ZOMBIE": 
            case "ZOMBIFIED_PIGLIN": {
                if (BukkitBabyPigZombie.isInstanceOf(e)) {
                    return MythicEntityType.BABY_PIG_ZOMBIE;
                }
                if (BukkitBabyPigZombieVillager.isInstanceOf(e)) {
                    return MythicEntityType.BABY_PIG_ZOMBIE_VILLAGER;
                }
                if (BukkitPigZombie.isInstanceOf(e)) {
                    return MythicEntityType.ZOMBIFIED_PIGLIN;
                }
                if (!BukkitPigZombieVillager.isInstanceOf(e)) break;
                return MythicEntityType.ZOMBIFIED_PIGLIN_VILLAGER;
            }
            case "PIGLIN": {
                if (BukkitBabyPiglin.isInstanceOf(e)) {
                    return MythicEntityType.BABY_PIGLIN;
                }
            }
            case "ZOMBIE": {
                if (BukkitBabyZombie.isInstanceOf(e)) {
                    return MythicEntityType.BABY_ZOMBIE;
                }
                if (!BukkitBabyZombieVillager.isInstanceOf(e)) break;
                return MythicEntityType.BABY_ZOMBIE_VILLAGER;
            }
        }
        return MythicEntityType.get(type);
    }

    @Override
    public void handleMobDespawnEvent(ActiveMob mob) {
        Schedulers.of(mob.getEntity().getBukkitEntity()).run(() -> {
            MythicMobDespawnEvent mythicDespawnEvent = new MythicMobDespawnEvent(mob);
            Events.call(mythicDespawnEvent);
        });
    }

    @Override
    public AbstractFirework createFirework(String type, int duration, Collection<Color> colors, Collection<Color> fadeColors, boolean flicker, boolean trail) {
        return new BukkitFirework(type, duration, colors, fadeColors, flicker, trail);
    }

    public void initializeMagicEntityValues() {
        for (MythicEntityType mythicEntityType : MythicEntityType.values()) {
            if (mythicEntityType == MythicEntityType.CUSTOM) continue;
            try {
                mythicEntityType.initializeDefaultValues();
            }
            catch (Throwable ex) {
                MythicLogger.error("Error initializing default entity magic values. Please report this.");
                ex.printStackTrace();
            }
        }
    }

    @Override
    public AbstractItemConsumableComponent createItemConsumableComponent(MythicItem mythicItem, MythicConfig config) {
        return this.platformBridge.createItemConsumableComponent(mythicItem, config);
    }

    @Override
    public AbstractItemDeathProtectionComponent createItemDeathProtectionComponent(MythicItem mythicItem, MythicConfig config) {
        return this.platformBridge.createItemDeathProtectionComponent(mythicItem, config);
    }

    @Override
    public AbstractTeleportData createTeleportData(MythicLineConfig mlc) {
        return this.platformBridge.createTeleportData(mlc);
    }
}

