/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.skills;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.auras.AuraRegistry;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import java.util.Collection;

public interface SkillCaster {
    public AbstractEntity getEntity();

    default public AbstractLocation getLocation() {
        return this.getEntity().getLocation();
    }

    public void setUsingDamageSkill(boolean var1);

    public boolean isUsingDamageSkill();

    default public double getLevel() {
        return 1.0;
    }

    default public float getPower() {
        return 1.0f;
    }

    default public int getGlobalCooldown() {
        return 0;
    }

    default public void setGlobalCooldown(int ticks) {
    }

    default public void setSkillCooldownMillis(AbstractSkill skill, double millis) {
        MythicProvider.get().getSkillManager().setSkillCooldown(this, skill, millis);
    }

    default public void setSkillCooldownSeconds(AbstractSkill skill, double seconds) {
        this.setSkillCooldownMillis(skill, seconds * 1000.0);
    }

    default public void setSkillCooldownTicks(AbstractSkill skill, int ticks) {
        this.setSkillCooldownMillis(skill, (double)ticks * 50.0);
    }

    default public boolean isSkillOnCooldown(AbstractSkill skill) {
        return this.getSkillCooldownRemainingMillis(skill) > 0.0;
    }

    default public double getSkillCooldownRemainingMillis(AbstractSkill skill) {
        return MythicProvider.get().getSkillManager().getSkillCooldownRemainingMillis(this, skill);
    }

    default public double getSkillCooldownRemainingSeconds(AbstractSkill skill) {
        double remaining = this.getSkillCooldownRemainingMillis(skill);
        return remaining > 0.0 ? remaining / 1000.0 : 0.0;
    }

    default public AuraRegistry getAuraRegistry() {
        return MythicProvider.get().getSkillManager().getAuraManager().getAuraRegistry(this.getEntity());
    }

    default public void registerAura(String buffName, Aura.AuraTracker buff) {
        if (this.getAuraRegistry() != null) {
            this.getAuraRegistry().registerAura(buffName, buff);
        }
    }

    default public void unregisterAura(String buffName, Aura.AuraTracker buff) {
        if (this.getAuraRegistry() != null) {
            this.getAuraRegistry().unregisterAura(buffName, buff);
        }
    }

    default public boolean hasAura(String auraName) {
        return MythicProvider.get().getSkillManager().getAuraManager().getHasAura(this.getEntity(), auraName);
    }

    default public int getAuraStacks(String auraName) {
        return MythicProvider.get().getSkillManager().getAuraManager().getAuraStacks(this.getEntity(), auraName);
    }

    default public void addChild(AbstractEntity entity) {
    }

    default public void removeChild(AbstractEntity entity) {
    }

    default public Collection<AbstractEntity> getChildren() {
        return Sets.newConcurrentHashSet();
    }

    default public String getName() {
        if (this.getEntity() == null) {
            return "Unknown";
        }
        return this.getEntity().getName();
    }

    default public StatRegistry getStatRegistry() {
        return null;
    }
}

