/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import org.bukkit.inventory.ItemStack;

public class AbstractItemUseRemainderComponent
implements AbstractItemComponent {
    private PlaceholderString remainderItemName;

    public AbstractItemUseRemainderComponent(MythicItem mythicItem, MythicConfig config) {
        this.remainderItemName = config.getPlaceholderString(new String[]{"UseRemainder", "Options.UseRemainder"}, null);
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyUseRemainderComponent(dropMetadata, this);
    }

    public ItemStack resolveRemainderItem(DropMetadata dropMetadata) {
        if (this.remainderItemName == null) {
            return null;
        }
        String remainderName = this.remainderItemName.get(dropMetadata);
        if (remainderName == null || remainderName.isEmpty()) {
            return null;
        }
        ItemStack remainderItem = MythicBukkit.inst().getItemManager().getItemStack(remainderName);
        if (remainderItem == null) {
            MythicLogger.error("UseRemainder component item not found: {0}", remainderName);
        }
        return remainderItem;
    }

    public PlaceholderString getRemainderItemName() {
        return this.remainderItemName;
    }

    public void setRemainderItemName(PlaceholderString remainderItemName) {
        this.remainderItemName = remainderItemName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemUseRemainderComponent)) {
            return false;
        }
        AbstractItemUseRemainderComponent other = (AbstractItemUseRemainderComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlaceholderString this$remainderItemName = this.getRemainderItemName();
        PlaceholderString other$remainderItemName = other.getRemainderItemName();
        return !(this$remainderItemName == null ? other$remainderItemName != null : !this$remainderItemName.equals(other$remainderItemName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemUseRemainderComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlaceholderString $remainderItemName = this.getRemainderItemName();
        result = result * 59 + ($remainderItemName == null ? 43 : $remainderItemName.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemUseRemainderComponent(remainderItemName=" + String.valueOf(this.getRemainderItemName()) + ")";
    }
}

