/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.items.MythicItem;

public class AbstractItemTrimComponent
implements AbstractItemComponent {
    private PlaceholderString trimMaterial;
    private PlaceholderString trimPattern;

    public AbstractItemTrimComponent(MythicItem mythicItem, MythicConfig config) {
        this.trimMaterial = config.getPlaceholderString("Material", "IRON");
        this.trimPattern = config.getPlaceholderString("Pattern", "WILD");
    }

    public AbstractItemTrimComponent(MythicItem mythicItem, String trimMaterial, String trimPattern) {
        this.trimMaterial = PlaceholderString.of(trimMaterial);
        this.trimPattern = PlaceholderString.of(trimPattern);
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyTrimComponent(dropMetadata, this);
    }

    public void setTrimMaterial(PlaceholderString trimMaterial) {
        this.trimMaterial = trimMaterial;
    }

    public void setTrimPattern(PlaceholderString trimPattern) {
        this.trimPattern = trimPattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemTrimComponent)) {
            return false;
        }
        AbstractItemTrimComponent other = (AbstractItemTrimComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlaceholderString this$trimMaterial = this.getTrimMaterial();
        PlaceholderString other$trimMaterial = other.getTrimMaterial();
        if (this$trimMaterial == null ? other$trimMaterial != null : !this$trimMaterial.equals(other$trimMaterial)) {
            return false;
        }
        PlaceholderString this$trimPattern = this.getTrimPattern();
        PlaceholderString other$trimPattern = other.getTrimPattern();
        return !(this$trimPattern == null ? other$trimPattern != null : !this$trimPattern.equals(other$trimPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemTrimComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlaceholderString $trimMaterial = this.getTrimMaterial();
        result = result * 59 + ($trimMaterial == null ? 43 : $trimMaterial.hashCode());
        PlaceholderString $trimPattern = this.getTrimPattern();
        result = result * 59 + ($trimPattern == null ? 43 : $trimPattern.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemTrimComponent(trimMaterial=" + String.valueOf(this.getTrimMaterial()) + ", trimPattern=" + String.valueOf(this.getTrimPattern()) + ")";
    }

    public PlaceholderString getTrimMaterial() {
        return this.trimMaterial;
    }

    public PlaceholderString getTrimPattern() {
        return this.trimPattern;
    }
}

