/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AbstractItemSpawnerComponent
implements AbstractItemComponent {
    private Integer delay;
    private Integer maxSpawnDelay;
    private Integer minSpawnDelay;
    private Integer requiredPlayerRange;
    private Integer spawnCount;
    private Integer spawnRange;
    private Integer maxNearbyEntities;
    private Collection<PotentialSpawns> potentialSpawns = Lists.newArrayList();

    public AbstractItemSpawnerComponent(MythicItem item, MythicConfig config) {
        if (config.isSet("Delay")) {
            this.delay = config.getInteger("Delay");
        }
        if (config.isSet("MaxSpawnDelay")) {
            this.maxSpawnDelay = config.getInteger("MaxSpawnDelay");
        }
        if (config.isSet("MinSpawnDelay")) {
            this.minSpawnDelay = config.getInteger("MinSpawnDelay");
        }
        if (config.isSet("RequiredPlayerRange")) {
            this.requiredPlayerRange = config.getInteger("RequiredPlayerRange");
        }
        if (config.isSet("SpawnCount")) {
            this.spawnCount = config.getInteger("SpawnCount");
        }
        if (config.isSet("SpawnRange")) {
            this.spawnRange = config.getInteger("SpawnRange");
        }
        if (config.isSet("MaxNearbyEntities")) {
            this.maxNearbyEntities = config.getInteger("MaxNearbyEntities");
        }
        if (config.isSet("Mobs")) {
            if (config.isList("Mobs") && !config.getStringList("Mobs").isEmpty()) {
                for (String line : config.getStringList("Mobs")) {
                    String[] split = line.split(" ");
                    String type = split[0];
                    int weight = 1;
                    if (split.length > 1) {
                        try {
                            weight = Integer.parseInt(split[1]);
                        }
                        catch (NumberFormatException e) {
                            MythicLogger.errorItemConfig(item, config, "Invalid weight for spawner item");
                        }
                    }
                    this.potentialSpawns.add(new PotentialSpawns(type, weight));
                }
            } else {
                List<Map<?, ?>> mobs = config.getMapList("Mobs");
                for (Map<?, ?> mob : mobs) {
                    PotentialSpawns spawn = new PotentialSpawns(mob);
                    this.potentialSpawns.add(spawn);
                }
            }
        } else if (config.isSet("Mob")) {
            String mob = config.getString("Mob");
            this.potentialSpawns.add(new PotentialSpawns(mob));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyMobSpawnerComponent(this);
    }

    public Integer getDelay() {
        return this.delay;
    }

    public Integer getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    public Integer getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    public Integer getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public Integer getSpawnCount() {
        return this.spawnCount;
    }

    public Integer getSpawnRange() {
        return this.spawnRange;
    }

    public Integer getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    public Collection<PotentialSpawns> getPotentialSpawns() {
        return this.potentialSpawns;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public void setMaxSpawnDelay(Integer maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
    }

    public void setMinSpawnDelay(Integer minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
    }

    public void setRequiredPlayerRange(Integer requiredPlayerRange) {
        this.requiredPlayerRange = requiredPlayerRange;
    }

    public void setSpawnCount(Integer spawnCount) {
        this.spawnCount = spawnCount;
    }

    public void setSpawnRange(Integer spawnRange) {
        this.spawnRange = spawnRange;
    }

    public void setMaxNearbyEntities(Integer maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    public void setPotentialSpawns(Collection<PotentialSpawns> potentialSpawns) {
        this.potentialSpawns = potentialSpawns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemSpawnerComponent)) {
            return false;
        }
        AbstractItemSpawnerComponent other = (AbstractItemSpawnerComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$delay = this.getDelay();
        Integer other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Integer this$maxSpawnDelay = this.getMaxSpawnDelay();
        Integer other$maxSpawnDelay = other.getMaxSpawnDelay();
        if (this$maxSpawnDelay == null ? other$maxSpawnDelay != null : !((Object)this$maxSpawnDelay).equals(other$maxSpawnDelay)) {
            return false;
        }
        Integer this$minSpawnDelay = this.getMinSpawnDelay();
        Integer other$minSpawnDelay = other.getMinSpawnDelay();
        if (this$minSpawnDelay == null ? other$minSpawnDelay != null : !((Object)this$minSpawnDelay).equals(other$minSpawnDelay)) {
            return false;
        }
        Integer this$requiredPlayerRange = this.getRequiredPlayerRange();
        Integer other$requiredPlayerRange = other.getRequiredPlayerRange();
        if (this$requiredPlayerRange == null ? other$requiredPlayerRange != null : !((Object)this$requiredPlayerRange).equals(other$requiredPlayerRange)) {
            return false;
        }
        Integer this$spawnCount = this.getSpawnCount();
        Integer other$spawnCount = other.getSpawnCount();
        if (this$spawnCount == null ? other$spawnCount != null : !((Object)this$spawnCount).equals(other$spawnCount)) {
            return false;
        }
        Integer this$spawnRange = this.getSpawnRange();
        Integer other$spawnRange = other.getSpawnRange();
        if (this$spawnRange == null ? other$spawnRange != null : !((Object)this$spawnRange).equals(other$spawnRange)) {
            return false;
        }
        Integer this$maxNearbyEntities = this.getMaxNearbyEntities();
        Integer other$maxNearbyEntities = other.getMaxNearbyEntities();
        if (this$maxNearbyEntities == null ? other$maxNearbyEntities != null : !((Object)this$maxNearbyEntities).equals(other$maxNearbyEntities)) {
            return false;
        }
        Collection<PotentialSpawns> this$potentialSpawns = this.getPotentialSpawns();
        Collection<PotentialSpawns> other$potentialSpawns = other.getPotentialSpawns();
        return !(this$potentialSpawns == null ? other$potentialSpawns != null : !((Object)this$potentialSpawns).equals(other$potentialSpawns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemSpawnerComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Integer $maxSpawnDelay = this.getMaxSpawnDelay();
        result = result * 59 + ($maxSpawnDelay == null ? 43 : ((Object)$maxSpawnDelay).hashCode());
        Integer $minSpawnDelay = this.getMinSpawnDelay();
        result = result * 59 + ($minSpawnDelay == null ? 43 : ((Object)$minSpawnDelay).hashCode());
        Integer $requiredPlayerRange = this.getRequiredPlayerRange();
        result = result * 59 + ($requiredPlayerRange == null ? 43 : ((Object)$requiredPlayerRange).hashCode());
        Integer $spawnCount = this.getSpawnCount();
        result = result * 59 + ($spawnCount == null ? 43 : ((Object)$spawnCount).hashCode());
        Integer $spawnRange = this.getSpawnRange();
        result = result * 59 + ($spawnRange == null ? 43 : ((Object)$spawnRange).hashCode());
        Integer $maxNearbyEntities = this.getMaxNearbyEntities();
        result = result * 59 + ($maxNearbyEntities == null ? 43 : ((Object)$maxNearbyEntities).hashCode());
        Collection<PotentialSpawns> $potentialSpawns = this.getPotentialSpawns();
        result = result * 59 + ($potentialSpawns == null ? 43 : ((Object)$potentialSpawns).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemSpawnerComponent(delay=" + this.getDelay() + ", maxSpawnDelay=" + this.getMaxSpawnDelay() + ", minSpawnDelay=" + this.getMinSpawnDelay() + ", requiredPlayerRange=" + this.getRequiredPlayerRange() + ", spawnCount=" + this.getSpawnCount() + ", spawnRange=" + this.getSpawnRange() + ", maxNearbyEntities=" + this.getMaxNearbyEntities() + ", potentialSpawns=" + String.valueOf(this.getPotentialSpawns()) + ")";
    }

    public class PotentialSpawns {
        private String type;
        private int weight;
        private int minBlockLight;
        private int maxBlockLight;
        private int minSkyLight;
        private int maxSkyLight;

        public PotentialSpawns(String type) {
            this.type = type;
            this.weight = 1;
            this.minBlockLight = 0;
            this.maxBlockLight = 7;
            this.minSkyLight = 0;
            this.maxSkyLight = 7;
        }

        public PotentialSpawns(String type, int weight) {
            this.type = type;
            this.weight = weight;
            this.minBlockLight = 0;
            this.maxBlockLight = 7;
            this.minSkyLight = 0;
            this.maxSkyLight = 7;
        }

        public PotentialSpawns(Map<?, ?> traits) {
            this.type = (String)traits.get("Type");
            if (this.type == null) {
                this.type = "PIG";
            }
            if (traits.containsKey("Weight")) {
                this.weight = (Integer)traits.get("Weight");
            }
            if (traits.containsKey("MinLight")) {
                this.minSkyLight = this.minBlockLight = ((Integer)traits.get("MinLight")).intValue();
            }
            if (traits.containsKey("MaxLight")) {
                this.maxSkyLight = this.maxBlockLight = ((Integer)traits.get("MaxLight")).intValue();
            }
            if (traits.containsKey("MinBlockLight")) {
                this.minBlockLight = (Integer)traits.get("MinBlockLight");
            }
            if (traits.containsKey("MaxBlockLight")) {
                this.maxBlockLight = (Integer)traits.get("MaxBlockLight");
            }
            if (traits.containsKey("MinSkyLight")) {
                this.minSkyLight = (Integer)traits.get("MinSkyLight");
            }
            if (traits.containsKey("MaxSkyLight")) {
                this.maxSkyLight = (Integer)traits.get("MaxSkyLight");
            }
        }

        public String getType() {
            return this.type;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getMinBlockLight() {
            return this.minBlockLight;
        }

        public int getMaxBlockLight() {
            return this.maxBlockLight;
        }

        public int getMinSkyLight() {
            return this.minSkyLight;
        }

        public int getMaxSkyLight() {
            return this.maxSkyLight;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public void setMinBlockLight(int minBlockLight) {
            this.minBlockLight = minBlockLight;
        }

        public void setMaxBlockLight(int maxBlockLight) {
            this.maxBlockLight = maxBlockLight;
        }

        public void setMinSkyLight(int minSkyLight) {
            this.minSkyLight = minSkyLight;
        }

        public void setMaxSkyLight(int maxSkyLight) {
            this.maxSkyLight = maxSkyLight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PotentialSpawns)) {
                return false;
            }
            PotentialSpawns other = (PotentialSpawns)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWeight() != other.getWeight()) {
                return false;
            }
            if (this.getMinBlockLight() != other.getMinBlockLight()) {
                return false;
            }
            if (this.getMaxBlockLight() != other.getMaxBlockLight()) {
                return false;
            }
            if (this.getMinSkyLight() != other.getMinSkyLight()) {
                return false;
            }
            if (this.getMaxSkyLight() != other.getMaxSkyLight()) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PotentialSpawns;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWeight();
            result = result * 59 + this.getMinBlockLight();
            result = result * 59 + this.getMaxBlockLight();
            result = result * 59 + this.getMinSkyLight();
            result = result * 59 + this.getMaxSkyLight();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractItemSpawnerComponent.PotentialSpawns(type=" + this.getType() + ", weight=" + this.getWeight() + ", minBlockLight=" + this.getMinBlockLight() + ", maxBlockLight=" + this.getMaxBlockLight() + ", minSkyLight=" + this.getMinSkyLight() + ", maxSkyLight=" + this.getMaxSkyLight() + ")";
        }
    }
}

