/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AbstractItemRepairableComponent
implements AbstractItemComponent {
    private List<String> itemTypes = Collections.emptyList();

    public AbstractItemRepairableComponent(MythicItem mythicItem, MythicConfig config) {
        List<String> items = null;
        if (config.isList("RepairableBy")) {
            items = config.getStringList("Repairable.Items");
        } else if (config.isSet("RepairableBy")) {
            items = List.of(config.getString("Repairable.Item"));
        }
        if (items != null && !items.isEmpty()) {
            this.itemTypes = items.stream().filter(Objects::nonNull).map(String::trim).filter(s2 -> !s2.isEmpty()).toList();
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyRepairableComponent(dropMetadata, this);
    }

    public List<String> getItemTypes() {
        return this.itemTypes;
    }

    public void setItemTypes(List<String> itemTypes) {
        this.itemTypes = itemTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemRepairableComponent)) {
            return false;
        }
        AbstractItemRepairableComponent other = (AbstractItemRepairableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$itemTypes = this.getItemTypes();
        List<String> other$itemTypes = other.getItemTypes();
        return !(this$itemTypes == null ? other$itemTypes != null : !((Object)this$itemTypes).equals(other$itemTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemRepairableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $itemTypes = this.getItemTypes();
        result = result * 59 + ($itemTypes == null ? 43 : ((Object)$itemTypes).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemRepairableComponent(itemTypes=" + String.valueOf(this.getItemTypes()) + ")";
    }
}

