/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.List;

public class AbstractItemPotDecorationsComponent
implements AbstractItemComponent {
    private String back;
    private String left;
    private String right;
    private String front;

    public AbstractItemPotDecorationsComponent(MythicItem mythicItem, MythicConfig config) {
        List<String> list;
        List<String> list2 = list = config.isList("PotDecorations") ? config.getStringList("PotDecorations") : null;
        if (list != null && list.size() == 4) {
            this.back = MythicConfig.normalizeNamespacedKey(list.get(0));
            this.left = MythicConfig.normalizeNamespacedKey(list.get(1));
            this.right = MythicConfig.normalizeNamespacedKey(list.get(2));
            this.front = MythicConfig.normalizeNamespacedKey(list.get(3));
            return;
        }
        if (list != null && !list.isEmpty()) {
            MythicLogger.errorGenericConfig(config, "PotDecorations must have exactly 4 entries (back, left, right, front)");
        }
        this.back = MythicConfig.normalizeNamespacedKey(config.getString("PotDecorations.Back", null));
        this.left = MythicConfig.normalizeNamespacedKey(config.getString("PotDecorations.Left", null));
        this.right = MythicConfig.normalizeNamespacedKey(config.getString("PotDecorations.Right", null));
        this.front = MythicConfig.normalizeNamespacedKey(config.getString("PotDecorations.Front", null));
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyPotDecorationsComponent(dropMetadata, this);
    }

    public String getBack() {
        return this.back;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public String getFront() {
        return this.front;
    }

    public void setBack(String back) {
        this.back = back;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public void setFront(String front) {
        this.front = front;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemPotDecorationsComponent)) {
            return false;
        }
        AbstractItemPotDecorationsComponent other = (AbstractItemPotDecorationsComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$back = this.getBack();
        String other$back = other.getBack();
        if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
            return false;
        }
        String this$left = this.getLeft();
        String other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        String this$right = this.getRight();
        String other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
            return false;
        }
        String this$front = this.getFront();
        String other$front = other.getFront();
        return !(this$front == null ? other$front != null : !this$front.equals(other$front));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemPotDecorationsComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $back = this.getBack();
        result = result * 59 + ($back == null ? 43 : $back.hashCode());
        String $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        String $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        String $front = this.getFront();
        result = result * 59 + ($front == null ? 43 : $front.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemPotDecorationsComponent(back=" + this.getBack() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ", front=" + this.getFront() + ")";
    }
}

