/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;

public class AbstractItemPiercingWeaponComponent
implements AbstractItemComponent {
    private Boolean dealsKnockback;
    private Boolean dismounts;
    private String sound;
    private String hitSound;

    public AbstractItemPiercingWeaponComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("PiercingWeapon.DealsKnockback")) {
            this.dealsKnockback = config.getBoolean("PiercingWeapon.DealsKnockback");
        } else if (config.isSet("PiercingWeapon.Knockback")) {
            this.dealsKnockback = config.getBoolean("PiercingWeapon.Knockback");
        }
        if (config.isSet("PiercingWeapon.Dismounts")) {
            this.dismounts = config.getBoolean("PiercingWeapon.Dismounts");
        }
        if (config.isSet("PiercingWeapon.Sound")) {
            this.sound = MythicConfig.normalizeNamespacedKey(config.getString("PiercingWeapon.Sound"));
        }
        if (config.isSet("PiercingWeapon.HitSound")) {
            this.hitSound = MythicConfig.normalizeNamespacedKey(config.getString("PiercingWeapon.HitSound"));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyPiercingWeaponComponent(dropMetadata, this);
    }

    public Boolean getDealsKnockback() {
        return this.dealsKnockback;
    }

    public Boolean getDismounts() {
        return this.dismounts;
    }

    public String getSound() {
        return this.sound;
    }

    public String getHitSound() {
        return this.hitSound;
    }

    public void setDealsKnockback(Boolean dealsKnockback) {
        this.dealsKnockback = dealsKnockback;
    }

    public void setDismounts(Boolean dismounts) {
        this.dismounts = dismounts;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public void setHitSound(String hitSound) {
        this.hitSound = hitSound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemPiercingWeaponComponent)) {
            return false;
        }
        AbstractItemPiercingWeaponComponent other = (AbstractItemPiercingWeaponComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$dealsKnockback = this.getDealsKnockback();
        Boolean other$dealsKnockback = other.getDealsKnockback();
        if (this$dealsKnockback == null ? other$dealsKnockback != null : !((Object)this$dealsKnockback).equals(other$dealsKnockback)) {
            return false;
        }
        Boolean this$dismounts = this.getDismounts();
        Boolean other$dismounts = other.getDismounts();
        if (this$dismounts == null ? other$dismounts != null : !((Object)this$dismounts).equals(other$dismounts)) {
            return false;
        }
        String this$sound = this.getSound();
        String other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        String this$hitSound = this.getHitSound();
        String other$hitSound = other.getHitSound();
        return !(this$hitSound == null ? other$hitSound != null : !this$hitSound.equals(other$hitSound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemPiercingWeaponComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $dealsKnockback = this.getDealsKnockback();
        result = result * 59 + ($dealsKnockback == null ? 43 : ((Object)$dealsKnockback).hashCode());
        Boolean $dismounts = this.getDismounts();
        result = result * 59 + ($dismounts == null ? 43 : ((Object)$dismounts).hashCode());
        String $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        String $hitSound = this.getHitSound();
        result = result * 59 + ($hitSound == null ? 43 : $hitSound.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemPiercingWeaponComponent(dealsKnockback=" + this.getDealsKnockback() + ", dismounts=" + this.getDismounts() + ", sound=" + this.getSound() + ", hitSound=" + this.getHitSound() + ")";
    }
}

