/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;

public class AbstractItemOminousBottleAmplifierComponent
implements AbstractItemComponent {
    private Integer amplifier;

    public AbstractItemOminousBottleAmplifierComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("OminousBottleAmplifier")) {
            this.amplifier = config.getInteger("OminousBottleAmplifier");
        } else if (config.isSet("OminousBottle.Amplifier")) {
            this.amplifier = config.getInteger("OminousBottle.Amplifier");
        }
        if (this.amplifier != null && (this.amplifier < 0 || this.amplifier > 4)) {
            MythicLogger.errorGenericConfig(config, "OminousBottleAmplifier must be between 0 and 4, using 0 instead");
            this.amplifier = 0;
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyOminousBottleAmplifierComponent(dropMetadata, this);
    }

    public Integer getAmplifier() {
        return this.amplifier;
    }

    public void setAmplifier(Integer amplifier) {
        this.amplifier = amplifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemOminousBottleAmplifierComponent)) {
            return false;
        }
        AbstractItemOminousBottleAmplifierComponent other = (AbstractItemOminousBottleAmplifierComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$amplifier = this.getAmplifier();
        Integer other$amplifier = other.getAmplifier();
        return !(this$amplifier == null ? other$amplifier != null : !((Object)this$amplifier).equals(other$amplifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemOminousBottleAmplifierComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $amplifier = this.getAmplifier();
        result = result * 59 + ($amplifier == null ? 43 : ((Object)$amplifier).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemOminousBottleAmplifierComponent(amplifier=" + this.getAmplifier() + ")";
    }
}

