/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;

public class AbstractItemKineticWeaponComponent
implements AbstractItemComponent {
    private Integer contactCooldownTicks;
    private Integer delayTicks;
    private Float forwardMovement;
    private Float damageMultiplier;
    private String sound;
    private String hitSound;
    private ConditionConfig damageConditions;
    private ConditionConfig knockbackConditions;
    private ConditionConfig dismountConditions;

    public AbstractItemKineticWeaponComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("ContactCooldownTicks")) {
            this.contactCooldownTicks = config.getInteger("ContactCooldownTicks");
            if (this.contactCooldownTicks < 0) {
                MythicLogger.errorGenericConfig(config, "KineticWeapon.ContactCooldownTicks cannot be less than 0, using 0 instead");
                this.contactCooldownTicks = 0;
            }
        }
        if (config.isSet("DelayTicks")) {
            this.delayTicks = config.getInteger("DelayTicks");
            if (this.delayTicks < 0) {
                MythicLogger.errorGenericConfig(config, "KineticWeapon.DelayTicks cannot be less than 0, using 0 instead");
                this.delayTicks = 0;
            }
        }
        if (config.isSet("ForwardMovement")) {
            this.forwardMovement = Float.valueOf(config.getFloat("ForwardMovement"));
        }
        if (config.isSet("DamageMultiplier")) {
            this.damageMultiplier = Float.valueOf(config.getFloat("DamageMultiplier"));
        }
        if (config.isSet("Sound")) {
            this.sound = MythicConfig.normalizeNamespacedKey(config.getString("Sound"));
        }
        if (config.isSet("HitSound")) {
            this.hitSound = MythicConfig.normalizeNamespacedKey(config.getString("HitSound"));
        }
        if (config.isSet("DamageConditions")) {
            this.damageConditions = this.parseCondition(config.getNestedConfig("DamageConditions"));
        }
        if (config.isSet("KnockbackConditions")) {
            this.knockbackConditions = this.parseCondition(config.getNestedConfig("KnockbackConditions"));
        }
        if (config.isSet("DismountConditions")) {
            this.dismountConditions = this.parseCondition(config.getNestedConfig("DismountConditions"));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyKineticWeaponComponent(dropMetadata, this);
    }

    private ConditionConfig parseCondition(MythicConfig config) {
        Float minRelativeSpeed;
        Integer maxDurationTicks = config.isSet("MaxDurationTicks") ? Integer.valueOf(config.getInteger("MaxDurationTicks")) : null;
        Float minSpeed = config.isSet("MinSpeed") ? Float.valueOf(config.getFloat("MinSpeed")) : null;
        Float f = minRelativeSpeed = config.isSet("MinRelativeSpeed") ? Float.valueOf(config.getFloat("MinRelativeSpeed")) : null;
        if (maxDurationTicks != null && maxDurationTicks < 0) {
            MythicLogger.errorGenericConfig(config, "KineticWeapon condition MaxDurationTicks cannot be less than 0, using 0 instead");
            maxDurationTicks = 0;
        }
        if (maxDurationTicks == null && minSpeed == null && minRelativeSpeed == null) {
            return null;
        }
        return new ConditionConfig(maxDurationTicks, minSpeed, minRelativeSpeed);
    }

    public Integer getContactCooldownTicks() {
        return this.contactCooldownTicks;
    }

    public Integer getDelayTicks() {
        return this.delayTicks;
    }

    public Float getForwardMovement() {
        return this.forwardMovement;
    }

    public Float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public String getSound() {
        return this.sound;
    }

    public String getHitSound() {
        return this.hitSound;
    }

    public ConditionConfig getDamageConditions() {
        return this.damageConditions;
    }

    public ConditionConfig getKnockbackConditions() {
        return this.knockbackConditions;
    }

    public ConditionConfig getDismountConditions() {
        return this.dismountConditions;
    }

    public void setContactCooldownTicks(Integer contactCooldownTicks) {
        this.contactCooldownTicks = contactCooldownTicks;
    }

    public void setDelayTicks(Integer delayTicks) {
        this.delayTicks = delayTicks;
    }

    public void setForwardMovement(Float forwardMovement) {
        this.forwardMovement = forwardMovement;
    }

    public void setDamageMultiplier(Float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public void setHitSound(String hitSound) {
        this.hitSound = hitSound;
    }

    public void setDamageConditions(ConditionConfig damageConditions) {
        this.damageConditions = damageConditions;
    }

    public void setKnockbackConditions(ConditionConfig knockbackConditions) {
        this.knockbackConditions = knockbackConditions;
    }

    public void setDismountConditions(ConditionConfig dismountConditions) {
        this.dismountConditions = dismountConditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemKineticWeaponComponent)) {
            return false;
        }
        AbstractItemKineticWeaponComponent other = (AbstractItemKineticWeaponComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$contactCooldownTicks = this.getContactCooldownTicks();
        Integer other$contactCooldownTicks = other.getContactCooldownTicks();
        if (this$contactCooldownTicks == null ? other$contactCooldownTicks != null : !((Object)this$contactCooldownTicks).equals(other$contactCooldownTicks)) {
            return false;
        }
        Integer this$delayTicks = this.getDelayTicks();
        Integer other$delayTicks = other.getDelayTicks();
        if (this$delayTicks == null ? other$delayTicks != null : !((Object)this$delayTicks).equals(other$delayTicks)) {
            return false;
        }
        Float this$forwardMovement = this.getForwardMovement();
        Float other$forwardMovement = other.getForwardMovement();
        if (this$forwardMovement == null ? other$forwardMovement != null : !((Object)this$forwardMovement).equals(other$forwardMovement)) {
            return false;
        }
        Float this$damageMultiplier = this.getDamageMultiplier();
        Float other$damageMultiplier = other.getDamageMultiplier();
        if (this$damageMultiplier == null ? other$damageMultiplier != null : !((Object)this$damageMultiplier).equals(other$damageMultiplier)) {
            return false;
        }
        String this$sound = this.getSound();
        String other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        String this$hitSound = this.getHitSound();
        String other$hitSound = other.getHitSound();
        if (this$hitSound == null ? other$hitSound != null : !this$hitSound.equals(other$hitSound)) {
            return false;
        }
        ConditionConfig this$damageConditions = this.getDamageConditions();
        ConditionConfig other$damageConditions = other.getDamageConditions();
        if (this$damageConditions == null ? other$damageConditions != null : !((Object)this$damageConditions).equals(other$damageConditions)) {
            return false;
        }
        ConditionConfig this$knockbackConditions = this.getKnockbackConditions();
        ConditionConfig other$knockbackConditions = other.getKnockbackConditions();
        if (this$knockbackConditions == null ? other$knockbackConditions != null : !((Object)this$knockbackConditions).equals(other$knockbackConditions)) {
            return false;
        }
        ConditionConfig this$dismountConditions = this.getDismountConditions();
        ConditionConfig other$dismountConditions = other.getDismountConditions();
        return !(this$dismountConditions == null ? other$dismountConditions != null : !((Object)this$dismountConditions).equals(other$dismountConditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemKineticWeaponComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $contactCooldownTicks = this.getContactCooldownTicks();
        result = result * 59 + ($contactCooldownTicks == null ? 43 : ((Object)$contactCooldownTicks).hashCode());
        Integer $delayTicks = this.getDelayTicks();
        result = result * 59 + ($delayTicks == null ? 43 : ((Object)$delayTicks).hashCode());
        Float $forwardMovement = this.getForwardMovement();
        result = result * 59 + ($forwardMovement == null ? 43 : ((Object)$forwardMovement).hashCode());
        Float $damageMultiplier = this.getDamageMultiplier();
        result = result * 59 + ($damageMultiplier == null ? 43 : ((Object)$damageMultiplier).hashCode());
        String $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        String $hitSound = this.getHitSound();
        result = result * 59 + ($hitSound == null ? 43 : $hitSound.hashCode());
        ConditionConfig $damageConditions = this.getDamageConditions();
        result = result * 59 + ($damageConditions == null ? 43 : ((Object)$damageConditions).hashCode());
        ConditionConfig $knockbackConditions = this.getKnockbackConditions();
        result = result * 59 + ($knockbackConditions == null ? 43 : ((Object)$knockbackConditions).hashCode());
        ConditionConfig $dismountConditions = this.getDismountConditions();
        result = result * 59 + ($dismountConditions == null ? 43 : ((Object)$dismountConditions).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemKineticWeaponComponent(contactCooldownTicks=" + this.getContactCooldownTicks() + ", delayTicks=" + this.getDelayTicks() + ", forwardMovement=" + this.getForwardMovement() + ", damageMultiplier=" + this.getDamageMultiplier() + ", sound=" + this.getSound() + ", hitSound=" + this.getHitSound() + ", damageConditions=" + String.valueOf(this.getDamageConditions()) + ", knockbackConditions=" + String.valueOf(this.getKnockbackConditions()) + ", dismountConditions=" + String.valueOf(this.getDismountConditions()) + ")";
    }

    public static class ConditionConfig {
        private final Integer maxDurationTicks;
        private final Float minSpeed;
        private final Float minRelativeSpeed;

        public ConditionConfig(Integer maxDurationTicks, Float minSpeed, Float minRelativeSpeed) {
            this.maxDurationTicks = maxDurationTicks;
            this.minSpeed = minSpeed;
            this.minRelativeSpeed = minRelativeSpeed;
        }

        public Integer getMaxDurationTicks() {
            return this.maxDurationTicks;
        }

        public Float getMinSpeed() {
            return this.minSpeed;
        }

        public Float getMinRelativeSpeed() {
            return this.minRelativeSpeed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionConfig)) {
                return false;
            }
            ConditionConfig other = (ConditionConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxDurationTicks = this.getMaxDurationTicks();
            Integer other$maxDurationTicks = other.getMaxDurationTicks();
            if (this$maxDurationTicks == null ? other$maxDurationTicks != null : !((Object)this$maxDurationTicks).equals(other$maxDurationTicks)) {
                return false;
            }
            Float this$minSpeed = this.getMinSpeed();
            Float other$minSpeed = other.getMinSpeed();
            if (this$minSpeed == null ? other$minSpeed != null : !((Object)this$minSpeed).equals(other$minSpeed)) {
                return false;
            }
            Float this$minRelativeSpeed = this.getMinRelativeSpeed();
            Float other$minRelativeSpeed = other.getMinRelativeSpeed();
            return !(this$minRelativeSpeed == null ? other$minRelativeSpeed != null : !((Object)this$minRelativeSpeed).equals(other$minRelativeSpeed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConditionConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxDurationTicks = this.getMaxDurationTicks();
            result = result * 59 + ($maxDurationTicks == null ? 43 : ((Object)$maxDurationTicks).hashCode());
            Float $minSpeed = this.getMinSpeed();
            result = result * 59 + ($minSpeed == null ? 43 : ((Object)$minSpeed).hashCode());
            Float $minRelativeSpeed = this.getMinRelativeSpeed();
            result = result * 59 + ($minRelativeSpeed == null ? 43 : ((Object)$minRelativeSpeed).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractItemKineticWeaponComponent.ConditionConfig(maxDurationTicks=" + this.getMaxDurationTicks() + ", minSpeed=" + this.getMinSpeed() + ", minRelativeSpeed=" + this.getMinRelativeSpeed() + ")";
        }
    }
}

