/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Locale;
import net.kyori.adventure.key.Key;

public class AbstractItemJukeboxPlayableComponent
implements AbstractItemComponent {
    private Key songKey;

    public AbstractItemJukeboxPlayableComponent(MythicItem mythicItem, MythicConfig config) {
        Object songKeyName = config.getString(new String[]{"JukeboxPlayable", "Options.JukeboxPlayable"}, null, new String[0]);
        if (songKeyName == null) {
            return;
        }
        if (!((String)(songKeyName = ((String)songKeyName).toLowerCase(Locale.ROOT))).contains(":")) {
            songKeyName = "minecraft:" + (String)songKeyName;
        }
        try {
            this.songKey = Key.key((String)songKeyName);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorItemConfig(mythicItem, config, "Invalid JukeboxPlayable song key '" + (String)songKeyName + "'");
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyJukeboxPlayableComponent(dropMetadata, this);
    }

    public Key getSongKey() {
        return this.songKey;
    }

    public void setSongKey(Key songKey) {
        this.songKey = songKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemJukeboxPlayableComponent)) {
            return false;
        }
        AbstractItemJukeboxPlayableComponent other = (AbstractItemJukeboxPlayableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$songKey = this.getSongKey();
        Key other$songKey = other.getSongKey();
        return !(this$songKey == null ? other$songKey != null : !this$songKey.equals(other$songKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemJukeboxPlayableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $songKey = this.getSongKey();
        result = result * 59 + ($songKey == null ? 43 : $songKey.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemJukeboxPlayableComponent(songKey=" + String.valueOf(this.getSongKey()) + ")";
    }
}

