/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;

public class AbstractItemEnchantableComponent
implements AbstractItemComponent {
    private Integer value;

    public AbstractItemEnchantableComponent(MythicItem mythicItem, int enchantability) {
        this.value = enchantability;
    }

    public AbstractItemEnchantableComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("Value")) {
            this.value = config.getInt("Value");
        } else if (config.isSet("Enchantability")) {
            this.value = config.getInt("Enchantability");
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyEnchantableComponent(dropMetadata, this);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemEnchantableComponent)) {
            return false;
        }
        AbstractItemEnchantableComponent other = (AbstractItemEnchantableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$value = this.getValue();
        Integer other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemEnchantableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemEnchantableComponent(value=" + this.getValue() + ")";
    }
}

