/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;

public class AbstractItemConsumableComponent
implements AbstractItemComponent {
    private Float consumeSeconds = null;
    private Boolean hasConsumeParticles = null;
    private String animation = null;
    private String sound = null;

    public AbstractItemConsumableComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("ConsumeSeconds")) {
            this.consumeSeconds = Float.valueOf(config.getFloat("ConsumeSeconds", 1.6f));
        }
        if (config.isSet("HasParticles")) {
            this.hasConsumeParticles = config.getBoolean("HasParticles", true);
        }
        if (config.isSet("Animation")) {
            this.animation = config.getString("Animation", "");
        }
        if (config.isSet("Sound")) {
            this.sound = MythicConfig.normalizeNamespacedKey(config.getString("Sound", ""));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyConsumableComponent(this);
    }

    public Float getConsumeSeconds() {
        return this.consumeSeconds;
    }

    public Boolean getHasConsumeParticles() {
        return this.hasConsumeParticles;
    }

    public String getAnimation() {
        return this.animation;
    }

    public String getSound() {
        return this.sound;
    }

    public void setConsumeSeconds(Float consumeSeconds) {
        this.consumeSeconds = consumeSeconds;
    }

    public void setHasConsumeParticles(Boolean hasConsumeParticles) {
        this.hasConsumeParticles = hasConsumeParticles;
    }

    public void setAnimation(String animation) {
        this.animation = animation;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemConsumableComponent)) {
            return false;
        }
        AbstractItemConsumableComponent other = (AbstractItemConsumableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$consumeSeconds = this.getConsumeSeconds();
        Float other$consumeSeconds = other.getConsumeSeconds();
        if (this$consumeSeconds == null ? other$consumeSeconds != null : !((Object)this$consumeSeconds).equals(other$consumeSeconds)) {
            return false;
        }
        Boolean this$hasConsumeParticles = this.getHasConsumeParticles();
        Boolean other$hasConsumeParticles = other.getHasConsumeParticles();
        if (this$hasConsumeParticles == null ? other$hasConsumeParticles != null : !((Object)this$hasConsumeParticles).equals(other$hasConsumeParticles)) {
            return false;
        }
        String this$animation = this.getAnimation();
        String other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !this$animation.equals(other$animation)) {
            return false;
        }
        String this$sound = this.getSound();
        String other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemConsumableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $consumeSeconds = this.getConsumeSeconds();
        result = result * 59 + ($consumeSeconds == null ? 43 : ((Object)$consumeSeconds).hashCode());
        Boolean $hasConsumeParticles = this.getHasConsumeParticles();
        result = result * 59 + ($hasConsumeParticles == null ? 43 : ((Object)$hasConsumeParticles).hashCode());
        String $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : $animation.hashCode());
        String $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemConsumableComponent(consumeSeconds=" + this.getConsumeSeconds() + ", hasConsumeParticles=" + this.getHasConsumeParticles() + ", animation=" + this.getAnimation() + ", sound=" + this.getSound() + ")";
    }
}

