/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Locale;
import net.kyori.adventure.key.Key;

public class AbstractItemBreakSoundComponent
implements AbstractItemComponent {
    private Key key;

    public AbstractItemBreakSoundComponent(MythicItem mythicItem, MythicConfig config) {
        Object breakSound = config.getString(new String[]{"BreakSound", "Options.BreakSound"}, null, new String[0]);
        if (breakSound == null) {
            return;
        }
        if (!((String)(breakSound = ((String)breakSound).toLowerCase(Locale.ROOT))).contains(":")) {
            breakSound = "minecraft:" + (String)breakSound;
        }
        try {
            this.key = Key.key((String)breakSound);
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.errorItemConfig(mythicItem, config, "Invalid BreakSound '" + (String)breakSound + "'");
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyBreakSoundComponent(dropMetadata, this);
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemBreakSoundComponent)) {
            return false;
        }
        AbstractItemBreakSoundComponent other = (AbstractItemBreakSoundComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$key = this.getKey();
        Key other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemBreakSoundComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemBreakSoundComponent(key=" + String.valueOf(this.getKey()) + ")";
    }
}

