/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AbstractItemBlocksAttacksComponent
implements AbstractItemComponent {
    private Float blockDelaySeconds;
    private Float disableCooldownScale;
    private List<DamageReduction> damageReductions = new ArrayList<DamageReduction>();
    private ItemDamage itemDamage;
    private Object hitBlockSound;
    private Object disabledSound;
    private String bypassedBy;

    public AbstractItemBlocksAttacksComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("BlockDelaySeconds")) {
            this.blockDelaySeconds = Float.valueOf(config.getFloat("BlockDelaySeconds"));
            if (this.blockDelaySeconds.floatValue() < 0.0f) {
                MythicLogger.errorGenericConfig(config, "BlockDelaySeconds cannot be less than 0, using 0 instead");
                this.blockDelaySeconds = Float.valueOf(0.0f);
            }
        }
        if (config.isSet("DisableCooldownScale")) {
            this.disableCooldownScale = Float.valueOf(config.getFloat("DisableCooldownScale"));
            if (this.disableCooldownScale.floatValue() < 0.0f) {
                MythicLogger.errorGenericConfig(config, "DisableCooldownScale cannot be less than 0, using 1 instead");
                this.disableCooldownScale = Float.valueOf(1.0f);
            }
        }
        for (Map<?, ?> map : config.getMapList("DamageReductions")) {
            float angle;
            DamageTypeSelector selector = this.parseDamageTypeSelector(config, map.get("Type"));
            boolean hasBase = map.containsKey("Base");
            boolean hasFactor = map.containsKey("Factor");
            if (!hasBase && !hasFactor) {
                MythicLogger.errorGenericConfig(config, "DamageReductions entry must specify Base and/or Factor");
                continue;
            }
            float base = hasBase ? this.toFloat(map.get("Base"), 0.0f) : 0.0f;
            float factor = hasFactor ? this.toFloat(map.get("Factor"), 0.0f) : 0.0f;
            float f = angle = map.containsKey("HorizontalBlockingAngle") ? this.toFloat(map.get("HorizontalBlockingAngle"), 90.0f) : 90.0f;
            if (angle < 0.0f) {
                MythicLogger.errorGenericConfig(config, "HorizontalBlockingAngle cannot be less than 0, using 90 instead");
                angle = 90.0f;
            }
            this.damageReductions.add(new DamageReduction(selector, base, factor, angle));
        }
        if (config.isSet("ItemDamage")) {
            Float factor;
            MythicConfig sub = config.getNestedConfig("ItemDamage");
            Float threshold = sub.isSet("Threshold") ? Float.valueOf(sub.getFloat("Threshold")) : null;
            Float base = sub.isSet("Base") ? Float.valueOf(sub.getFloat("Base")) : null;
            Float f = factor = sub.isSet("Factor") ? Float.valueOf(sub.getFloat("Factor")) : null;
            if (threshold != null && threshold.floatValue() < 0.0f) {
                MythicLogger.errorGenericConfig(sub, "ItemDamage.Threshold cannot be less than 0, using 0 instead");
                threshold = Float.valueOf(0.0f);
            }
            if (base != null && base.floatValue() < 0.0f) {
                MythicLogger.errorGenericConfig(sub, "ItemDamage.Base cannot be less than 0, using 0 instead");
                base = Float.valueOf(0.0f);
            }
            if (factor != null && factor.floatValue() < 0.0f) {
                MythicLogger.errorGenericConfig(sub, "ItemDamage.Factor cannot be less than 0, using 1.5 instead");
                factor = Float.valueOf(1.5f);
            }
            this.itemDamage = new ItemDamage(threshold, base, factor);
        }
        if (config.isSet("HitBlockSound")) {
            this.hitBlockSound = MythicConfig.normalizeNamespacedKey(config.getString("HitBlockSound"));
        }
        if (config.isSet("DisabledSound")) {
            this.disabledSound = MythicConfig.normalizeNamespacedKey(config.getString("DisabledSound"));
        }
        if (config.isSet("BypassedBy")) {
            this.bypassedBy = MythicConfig.normalizeNamespacedKey(config.getString("BypassedBy"));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyBlocksAttacksComponent(dropMetadata, this);
    }

    private float toFloat(Object obj, float def) {
        return obj instanceof Number ? ((Number)obj).floatValue() : def;
    }

    private DamageTypeSelector parseDamageTypeSelector(MythicConfig config, Object typeObj) {
        if (typeObj == null) {
            return DamageTypeSelector.all();
        }
        if (typeObj instanceof String) {
            return new DamageTypeSelector((String)typeObj, null, false);
        }
        if (typeObj instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object o : (List)typeObj) {
                if (o == null) continue;
                list.add(String.valueOf(o));
            }
            return new DamageTypeSelector(null, list, false);
        }
        MythicLogger.errorGenericConfig(config, "DamageReductions.Type must be a String or List<String>");
        return DamageTypeSelector.all();
    }

    public Float getBlockDelaySeconds() {
        return this.blockDelaySeconds;
    }

    public Float getDisableCooldownScale() {
        return this.disableCooldownScale;
    }

    public List<DamageReduction> getDamageReductions() {
        return this.damageReductions;
    }

    public ItemDamage getItemDamage() {
        return this.itemDamage;
    }

    public Object getHitBlockSound() {
        return this.hitBlockSound;
    }

    public Object getDisabledSound() {
        return this.disabledSound;
    }

    public String getBypassedBy() {
        return this.bypassedBy;
    }

    public void setBlockDelaySeconds(Float blockDelaySeconds) {
        this.blockDelaySeconds = blockDelaySeconds;
    }

    public void setDisableCooldownScale(Float disableCooldownScale) {
        this.disableCooldownScale = disableCooldownScale;
    }

    public void setDamageReductions(List<DamageReduction> damageReductions) {
        this.damageReductions = damageReductions;
    }

    public void setItemDamage(ItemDamage itemDamage) {
        this.itemDamage = itemDamage;
    }

    public void setHitBlockSound(Object hitBlockSound) {
        this.hitBlockSound = hitBlockSound;
    }

    public void setDisabledSound(Object disabledSound) {
        this.disabledSound = disabledSound;
    }

    public void setBypassedBy(String bypassedBy) {
        this.bypassedBy = bypassedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemBlocksAttacksComponent)) {
            return false;
        }
        AbstractItemBlocksAttacksComponent other = (AbstractItemBlocksAttacksComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$blockDelaySeconds = this.getBlockDelaySeconds();
        Float other$blockDelaySeconds = other.getBlockDelaySeconds();
        if (this$blockDelaySeconds == null ? other$blockDelaySeconds != null : !((Object)this$blockDelaySeconds).equals(other$blockDelaySeconds)) {
            return false;
        }
        Float this$disableCooldownScale = this.getDisableCooldownScale();
        Float other$disableCooldownScale = other.getDisableCooldownScale();
        if (this$disableCooldownScale == null ? other$disableCooldownScale != null : !((Object)this$disableCooldownScale).equals(other$disableCooldownScale)) {
            return false;
        }
        List<DamageReduction> this$damageReductions = this.getDamageReductions();
        List<DamageReduction> other$damageReductions = other.getDamageReductions();
        if (this$damageReductions == null ? other$damageReductions != null : !((Object)this$damageReductions).equals(other$damageReductions)) {
            return false;
        }
        ItemDamage this$itemDamage = this.getItemDamage();
        ItemDamage other$itemDamage = other.getItemDamage();
        if (this$itemDamage == null ? other$itemDamage != null : !((Object)this$itemDamage).equals(other$itemDamage)) {
            return false;
        }
        Object this$hitBlockSound = this.getHitBlockSound();
        Object other$hitBlockSound = other.getHitBlockSound();
        if (this$hitBlockSound == null ? other$hitBlockSound != null : !this$hitBlockSound.equals(other$hitBlockSound)) {
            return false;
        }
        Object this$disabledSound = this.getDisabledSound();
        Object other$disabledSound = other.getDisabledSound();
        if (this$disabledSound == null ? other$disabledSound != null : !this$disabledSound.equals(other$disabledSound)) {
            return false;
        }
        String this$bypassedBy = this.getBypassedBy();
        String other$bypassedBy = other.getBypassedBy();
        return !(this$bypassedBy == null ? other$bypassedBy != null : !this$bypassedBy.equals(other$bypassedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemBlocksAttacksComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $blockDelaySeconds = this.getBlockDelaySeconds();
        result = result * 59 + ($blockDelaySeconds == null ? 43 : ((Object)$blockDelaySeconds).hashCode());
        Float $disableCooldownScale = this.getDisableCooldownScale();
        result = result * 59 + ($disableCooldownScale == null ? 43 : ((Object)$disableCooldownScale).hashCode());
        List<DamageReduction> $damageReductions = this.getDamageReductions();
        result = result * 59 + ($damageReductions == null ? 43 : ((Object)$damageReductions).hashCode());
        ItemDamage $itemDamage = this.getItemDamage();
        result = result * 59 + ($itemDamage == null ? 43 : ((Object)$itemDamage).hashCode());
        Object $hitBlockSound = this.getHitBlockSound();
        result = result * 59 + ($hitBlockSound == null ? 43 : $hitBlockSound.hashCode());
        Object $disabledSound = this.getDisabledSound();
        result = result * 59 + ($disabledSound == null ? 43 : $disabledSound.hashCode());
        String $bypassedBy = this.getBypassedBy();
        result = result * 59 + ($bypassedBy == null ? 43 : $bypassedBy.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemBlocksAttacksComponent(blockDelaySeconds=" + this.getBlockDelaySeconds() + ", disableCooldownScale=" + this.getDisableCooldownScale() + ", damageReductions=" + String.valueOf(this.getDamageReductions()) + ", itemDamage=" + String.valueOf(this.getItemDamage()) + ", hitBlockSound=" + String.valueOf(this.getHitBlockSound()) + ", disabledSound=" + String.valueOf(this.getDisabledSound()) + ", bypassedBy=" + this.getBypassedBy() + ")";
    }

    public static class DamageTypeSelector {
        private String single;
        private List<String> many;
        private boolean all;

        public static DamageTypeSelector all() {
            return new DamageTypeSelector(null, null, true);
        }

        public String getSingle() {
            return this.single;
        }

        public List<String> getMany() {
            return this.many;
        }

        public boolean isAll() {
            return this.all;
        }

        public void setSingle(String single) {
            this.single = single;
        }

        public void setMany(List<String> many) {
            this.many = many;
        }

        public void setAll(boolean all) {
            this.all = all;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DamageTypeSelector)) {
                return false;
            }
            DamageTypeSelector other = (DamageTypeSelector)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAll() != other.isAll()) {
                return false;
            }
            String this$single = this.getSingle();
            String other$single = other.getSingle();
            if (this$single == null ? other$single != null : !this$single.equals(other$single)) {
                return false;
            }
            List<String> this$many = this.getMany();
            List<String> other$many = other.getMany();
            return !(this$many == null ? other$many != null : !((Object)this$many).equals(other$many));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DamageTypeSelector;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAll() ? 79 : 97);
            String $single = this.getSingle();
            result = result * 59 + ($single == null ? 43 : $single.hashCode());
            List<String> $many = this.getMany();
            result = result * 59 + ($many == null ? 43 : ((Object)$many).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractItemBlocksAttacksComponent.DamageTypeSelector(single=" + this.getSingle() + ", many=" + String.valueOf(this.getMany()) + ", all=" + this.isAll() + ")";
        }

        public DamageTypeSelector(String single, List<String> many, boolean all) {
            this.single = single;
            this.many = many;
            this.all = all;
        }
    }

    public class DamageReduction {
        private DamageTypeSelector type;
        private float base;
        private float factor;
        private float horizontalBlockingAngle;

        public DamageTypeSelector getType() {
            return this.type;
        }

        public float getBase() {
            return this.base;
        }

        public float getFactor() {
            return this.factor;
        }

        public float getHorizontalBlockingAngle() {
            return this.horizontalBlockingAngle;
        }

        public void setType(DamageTypeSelector type) {
            this.type = type;
        }

        public void setBase(float base) {
            this.base = base;
        }

        public void setFactor(float factor) {
            this.factor = factor;
        }

        public void setHorizontalBlockingAngle(float horizontalBlockingAngle) {
            this.horizontalBlockingAngle = horizontalBlockingAngle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DamageReduction)) {
                return false;
            }
            DamageReduction other = (DamageReduction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getBase(), other.getBase()) != 0) {
                return false;
            }
            if (Float.compare(this.getFactor(), other.getFactor()) != 0) {
                return false;
            }
            if (Float.compare(this.getHorizontalBlockingAngle(), other.getHorizontalBlockingAngle()) != 0) {
                return false;
            }
            DamageTypeSelector this$type = this.getType();
            DamageTypeSelector other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DamageReduction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getBase());
            result = result * 59 + Float.floatToIntBits(this.getFactor());
            result = result * 59 + Float.floatToIntBits(this.getHorizontalBlockingAngle());
            DamageTypeSelector $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractItemBlocksAttacksComponent.DamageReduction(type=" + String.valueOf(this.getType()) + ", base=" + this.getBase() + ", factor=" + this.getFactor() + ", horizontalBlockingAngle=" + this.getHorizontalBlockingAngle() + ")";
        }

        public DamageReduction(DamageTypeSelector type, float base, float factor, float horizontalBlockingAngle) {
            this.type = type;
            this.base = base;
            this.factor = factor;
            this.horizontalBlockingAngle = horizontalBlockingAngle;
        }
    }

    public class ItemDamage {
        private Float threshold;
        private Float base;
        private Float factor;

        public Float getThreshold() {
            return this.threshold;
        }

        public Float getBase() {
            return this.base;
        }

        public Float getFactor() {
            return this.factor;
        }

        public void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        public void setBase(Float base) {
            this.base = base;
        }

        public void setFactor(Float factor) {
            this.factor = factor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemDamage)) {
                return false;
            }
            ItemDamage other = (ItemDamage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$threshold = this.getThreshold();
            Float other$threshold = other.getThreshold();
            if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
                return false;
            }
            Float this$base = this.getBase();
            Float other$base = other.getBase();
            if (this$base == null ? other$base != null : !((Object)this$base).equals(other$base)) {
                return false;
            }
            Float this$factor = this.getFactor();
            Float other$factor = other.getFactor();
            return !(this$factor == null ? other$factor != null : !((Object)this$factor).equals(other$factor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ItemDamage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $threshold = this.getThreshold();
            result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
            Float $base = this.getBase();
            result = result * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
            Float $factor = this.getFactor();
            result = result * 59 + ($factor == null ? 43 : ((Object)$factor).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractItemBlocksAttacksComponent.ItemDamage(threshold=" + this.getThreshold() + ", base=" + this.getBase() + ", factor=" + this.getFactor() + ")";
        }

        public ItemDamage(Float threshold, Float base, Float factor) {
            this.threshold = threshold;
            this.base = base;
            this.factor = factor;
        }
    }
}

