/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;

public class AbstractItemAttackRangeComponent
implements AbstractItemComponent {
    private Float minReach;
    private Float maxReach;
    private Float minCreativeReach;
    private Float maxCreativeReach;
    private Float hitboxMargin;
    private Float mobFactor;

    public AbstractItemAttackRangeComponent(MythicItem mythicItem, float maxReach) {
        this.maxReach = Float.valueOf(maxReach);
    }

    public AbstractItemAttackRangeComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("Min")) {
            this.minReach = Float.valueOf(config.getFloat("Min", 0.0f));
        }
        if (config.isSet("Max")) {
            this.maxReach = Float.valueOf(config.getFloat("Max", 3.0f));
        }
        if (config.isSet("MinCreative")) {
            this.minCreativeReach = Float.valueOf(config.getFloat("MinCreative", 0.0f));
        }
        if (config.isSet("MaxCreative")) {
            this.maxCreativeReach = Float.valueOf(config.getFloat("MaxCreative", 5.0f));
        }
        if (config.isSet("HitboxMargin")) {
            this.hitboxMargin = Float.valueOf(config.getFloat("HitboxMargin", 0.3f));
        }
        if (config.isSet("MobFactor")) {
            this.mobFactor = Float.valueOf(config.getFloat("MobFactor", 1.0f));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyAttackRangeComponent(dropMetadata, this);
    }

    public Float getMinReach() {
        return this.minReach;
    }

    public Float getMaxReach() {
        return this.maxReach;
    }

    public Float getMinCreativeReach() {
        return this.minCreativeReach;
    }

    public Float getMaxCreativeReach() {
        return this.maxCreativeReach;
    }

    public Float getHitboxMargin() {
        return this.hitboxMargin;
    }

    public Float getMobFactor() {
        return this.mobFactor;
    }

    public void setMinReach(Float minReach) {
        this.minReach = minReach;
    }

    public void setMaxReach(Float maxReach) {
        this.maxReach = maxReach;
    }

    public void setMinCreativeReach(Float minCreativeReach) {
        this.minCreativeReach = minCreativeReach;
    }

    public void setMaxCreativeReach(Float maxCreativeReach) {
        this.maxCreativeReach = maxCreativeReach;
    }

    public void setHitboxMargin(Float hitboxMargin) {
        this.hitboxMargin = hitboxMargin;
    }

    public void setMobFactor(Float mobFactor) {
        this.mobFactor = mobFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemAttackRangeComponent)) {
            return false;
        }
        AbstractItemAttackRangeComponent other = (AbstractItemAttackRangeComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$minReach = this.getMinReach();
        Float other$minReach = other.getMinReach();
        if (this$minReach == null ? other$minReach != null : !((Object)this$minReach).equals(other$minReach)) {
            return false;
        }
        Float this$maxReach = this.getMaxReach();
        Float other$maxReach = other.getMaxReach();
        if (this$maxReach == null ? other$maxReach != null : !((Object)this$maxReach).equals(other$maxReach)) {
            return false;
        }
        Float this$minCreativeReach = this.getMinCreativeReach();
        Float other$minCreativeReach = other.getMinCreativeReach();
        if (this$minCreativeReach == null ? other$minCreativeReach != null : !((Object)this$minCreativeReach).equals(other$minCreativeReach)) {
            return false;
        }
        Float this$maxCreativeReach = this.getMaxCreativeReach();
        Float other$maxCreativeReach = other.getMaxCreativeReach();
        if (this$maxCreativeReach == null ? other$maxCreativeReach != null : !((Object)this$maxCreativeReach).equals(other$maxCreativeReach)) {
            return false;
        }
        Float this$hitboxMargin = this.getHitboxMargin();
        Float other$hitboxMargin = other.getHitboxMargin();
        if (this$hitboxMargin == null ? other$hitboxMargin != null : !((Object)this$hitboxMargin).equals(other$hitboxMargin)) {
            return false;
        }
        Float this$mobFactor = this.getMobFactor();
        Float other$mobFactor = other.getMobFactor();
        return !(this$mobFactor == null ? other$mobFactor != null : !((Object)this$mobFactor).equals(other$mobFactor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemAttackRangeComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $minReach = this.getMinReach();
        result = result * 59 + ($minReach == null ? 43 : ((Object)$minReach).hashCode());
        Float $maxReach = this.getMaxReach();
        result = result * 59 + ($maxReach == null ? 43 : ((Object)$maxReach).hashCode());
        Float $minCreativeReach = this.getMinCreativeReach();
        result = result * 59 + ($minCreativeReach == null ? 43 : ((Object)$minCreativeReach).hashCode());
        Float $maxCreativeReach = this.getMaxCreativeReach();
        result = result * 59 + ($maxCreativeReach == null ? 43 : ((Object)$maxCreativeReach).hashCode());
        Float $hitboxMargin = this.getHitboxMargin();
        result = result * 59 + ($hitboxMargin == null ? 43 : ((Object)$hitboxMargin).hashCode());
        Float $mobFactor = this.getMobFactor();
        result = result * 59 + ($mobFactor == null ? 43 : ((Object)$mobFactor).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemAttackRangeComponent(minReach=" + this.getMinReach() + ", maxReach=" + this.getMaxReach() + ", minCreativeReach=" + this.getMinCreativeReach() + ", maxCreativeReach=" + this.getMaxCreativeReach() + ", hitboxMargin=" + this.getHitboxMargin() + ", mobFactor=" + this.getMobFactor() + ")";
    }
}

