/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters;

import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import java.util.OptionalInt;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public class AbstractItemModel {
    private NamespacedKey itemModel;
    private int model = 0;

    public static AbstractItemModel of(String modelInput) {
        return new AbstractItemModel(modelInput);
    }

    private AbstractItemModel(String modelInput) {
        OptionalInt maybeNumber = Numbers.parseInteger((String)modelInput);
        if (maybeNumber.isPresent()) {
            this.model = maybeNumber.getAsInt();
            this.itemModel = null;
        } else {
            if (!((String)modelInput).contains(":")) {
                modelInput = "minecraft:" + (String)modelInput;
            }
            this.itemModel = NamespacedKey.fromString((String)((String)modelInput).toLowerCase());
        }
    }

    public ItemStack apply(ItemStack stack) {
        return this.apply(ItemFactory.of(stack)).build();
    }

    public ItemFactory apply(ItemFactory factory) {
        if (this.itemModel != null) {
            return factory.itemModel(this.itemModel);
        }
        return factory.customModelData(this.model);
    }
}

