/*
 * Decompiled with CFR 0.152.
 */
package com.roklenarcic.util.strings.threshold;

import com.roklenarcic.util.strings.threshold.Thresholder;

public class RangeNodeThreshold
implements Thresholder {
    private double exponent;
    private double linearFactor;
    private double maxValue;
    private double constantFactor;

    public RangeNodeThreshold() {
        this(1.0);
    }

    public RangeNodeThreshold(double exponent) {
        this(exponent, 1.0, 0.65, 2.0);
    }

    public RangeNodeThreshold(double exponent, double linearFactor, double maxValue, double constantFactor) {
        this.exponent = exponent;
        this.linearFactor = linearFactor;
        this.maxValue = maxValue;
        this.constantFactor = constantFactor;
    }

    @Override
    public boolean isOverThreshold(int nodeSize, int nodeLevel, int keyIntervalSize) {
        if (keyIntervalSize <= 8) {
            return true;
        }
        int charArrayCost = nodeSize / 4 + 3;
        return (double)(nodeSize + charArrayCost) > (double)keyIntervalSize * (this.maxValue - this.linearFactor / Math.pow(this.constantFactor + (double)nodeLevel, this.exponent));
    }
}

