/*
 * Decompiled with CFR 0.152.
 */
package com.roklenarcic.util.strings;

import com.roklenarcic.util.strings.Queue;
import com.roklenarcic.util.strings.SetMatchListener;
import com.roklenarcic.util.strings.StringSet;
import com.roklenarcic.util.strings.WordCharacters;
import com.roklenarcic.util.strings.threshold.RangeNodeThreshold;
import com.roklenarcic.util.strings.threshold.Thresholder;

public class WholeWordLongestMatchSet
implements StringSet {
    private boolean caseSensitive = true;
    private TrieNode root;
    private boolean[] wordChars;

    public WholeWordLongestMatchSet(Iterable<String> keywords, boolean caseSensitive) {
        this(keywords, caseSensitive, new RangeNodeThreshold());
    }

    public WholeWordLongestMatchSet(Iterable<String> keywords, boolean caseSensitive, char[] wordCharacters) {
        this(keywords, caseSensitive, wordCharacters, new RangeNodeThreshold());
    }

    public WholeWordLongestMatchSet(Iterable<String> keywords, boolean caseSensitive, char[] wordCharacters, boolean[] toggleFlags) {
        this(keywords, caseSensitive, wordCharacters, toggleFlags, new RangeNodeThreshold());
    }

    public WholeWordLongestMatchSet(Iterable<String> keywords, boolean caseSensitive, char[] wordCharacters, boolean[] toggleFlags, Thresholder thresholdStrategy) {
        this.init(keywords, caseSensitive, WordCharacters.generateWordCharsFlags(wordCharacters, toggleFlags), thresholdStrategy);
    }

    public WholeWordLongestMatchSet(Iterable<String> keywords, boolean caseSensitive, char[] wordCharacters, Thresholder thresholdStrategy) {
        this.init(keywords, caseSensitive, WordCharacters.generateWordCharsFlags(wordCharacters), thresholdStrategy);
    }

    public WholeWordLongestMatchSet(Iterable<String> keywords, boolean caseSensitive, Thresholder thresholdStrategy) {
        this.init(keywords, caseSensitive, WordCharacters.generateWordCharsFlags(), thresholdStrategy);
    }

    @Override
    public void match(String haystack, SetMatchListener listener) {
        TrieNode currentNode = this.root;
        int idx = 0;
        int len = haystack.length();
        if (this.caseSensitive) {
            int failMatchEnd;
            while (idx < len) {
                char c = haystack.charAt(idx);
                TrieNode nextNode = currentNode.getTransition(c);
                if (nextNode == null) {
                    int failMatchEnd2;
                    if (!this.wordChars[c]) {
                        if (currentNode.matchLength != 0 ? !listener.match(haystack, idx - currentNode.matchLength, idx) : currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd2 = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd2)) {
                            return;
                        }
                    } else {
                        if (currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd2 = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd2)) {
                            return;
                        }
                        while (++idx < len && this.wordChars[haystack.charAt(idx)]) {
                        }
                    }
                    while (++idx < len && !this.wordChars[haystack.charAt(idx)]) {
                    }
                    currentNode = this.root;
                    continue;
                }
                ++idx;
                currentNode = nextNode;
            }
            if (currentNode.matchLength != 0 ? !listener.match(haystack, idx - currentNode.matchLength, idx) : currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd)) {
                return;
            }
        } else {
            int failMatchEnd;
            while (idx < len) {
                char c = Character.toLowerCase(haystack.charAt(idx));
                TrieNode nextNode = currentNode.getTransition(c);
                if (nextNode == null) {
                    int failMatchEnd3;
                    if (!this.wordChars[c]) {
                        if (currentNode.matchLength != 0 ? !listener.match(haystack, idx - currentNode.matchLength, idx) : currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd3 = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd3)) {
                            return;
                        }
                    } else {
                        if (currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd3 = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd3)) {
                            return;
                        }
                        while (++idx < len && this.wordChars[haystack.charAt(idx)]) {
                        }
                    }
                    while (++idx < len && !this.wordChars[haystack.charAt(idx)]) {
                    }
                    currentNode = this.root;
                    continue;
                }
                ++idx;
                currentNode = nextNode;
            }
            if (currentNode.matchLength != 0 ? !listener.match(haystack, idx - currentNode.matchLength, idx) : currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd)) {
                return;
            }
        }
    }

    boolean[] getWordChars() {
        return this.wordChars;
    }

    private void init(Iterable<String> keywords, boolean caseSensitive, final boolean[] wordChars, final Thresholder thresholdStrategy) {
        this.caseSensitive = caseSensitive;
        this.wordChars = wordChars;
        this.root = new HashmapNode();
        for (String keyword : keywords) {
            if (keyword == null || (keyword = WordCharacters.trim(keyword, wordChars)).length() <= 0) continue;
            HashmapNode currentNode = (HashmapNode)this.root;
            for (int idx = 0; idx < keyword.length(); ++idx) {
                currentNode = currentNode.getOrAddChild(caseSensitive ? keyword.charAt(idx) : Character.toLowerCase(keyword.charAt(idx)));
            }
            currentNode.matchLength = keyword.length();
        }
        final Queue<TrieNode> queue = new Queue<TrieNode>();
        this.root = this.root.optimizeNode(0, thresholdStrategy);
        queue.push(this.root);
        queue.push(null);
        final int[] level = new int[]{1};
        EntryVisitor optimizeNodesAndFailTransitions = new EntryVisitor(){

            @Override
            public void visit(TrieNode parent, char key, TrieNode value) {
                value = value.optimizeNode(level[0], thresholdStrategy);
                parent.updateTransition(key, value);
                if (parent.matchLength != 0 && !wordChars[key]) {
                    value.failMatchLength = parent.matchLength;
                    value.failMatchOffset = 1;
                } else {
                    value.failMatchLength = parent.failMatchLength;
                    value.failMatchOffset = parent.failMatchOffset + 1;
                }
                if (!value.isEmpty()) {
                    queue.push(value);
                }
            }
        };
        while (!queue.isEmpty()) {
            TrieNode n = (TrieNode)queue.take();
            if (n == null) {
                if (queue.isEmpty()) continue;
                queue.push(null);
                level[0] = level[0] + 1;
                continue;
            }
            n.mapEntries(optimizeNodesAndFailTransitions);
        }
    }

    private static abstract class TrieNode {
        protected int failMatchLength = 0;
        protected int failMatchOffset = 0;
        protected int matchLength = 0;

        private TrieNode() {
        }

        public abstract void clear();

        public abstract TrieNode getTransition(char var1);

        public abstract boolean isEmpty();

        public abstract void mapEntries(EntryVisitor var1);

        public abstract void updateTransition(char var1, TrieNode var2);

        protected TrieNode optimizeNode(int level, Thresholder thresholdStrategy) {
            return this;
        }
    }

    private static final class RangeNode
    extends TrieNode {
        private char baseChar = '\u0000';
        private TrieNode[] children;
        private int size = 0;

        private RangeNode(HashmapNode oldNode, char from, char to) {
            this.baseChar = from;
            this.size = to - from + 1;
            this.matchLength = oldNode.matchLength;
            if (this.size <= 0) {
                this.size = 0;
            } else {
                this.children = new TrieNode[this.size];
                for (int i = 0; i < oldNode.children.length; ++i) {
                    if (oldNode.children[i] == null) continue;
                    this.children[((HashmapNode)oldNode).keys[i] - from] = oldNode.children[i];
                }
            }
        }

        @Override
        public void clear() {
            this.children = null;
            this.size = 0;
        }

        @Override
        public TrieNode getTransition(char c) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                return this.children[idx];
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public void mapEntries(EntryVisitor visitor) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null || this.children[i] == this) continue;
                    visitor.visit(this, (char)(this.baseChar + i), this.children[i]);
                }
            }
        }

        @Override
        public void updateTransition(char c, TrieNode node) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                if (this.children[idx] != null) {
                    this.children[idx] = node;
                    return;
                }
                throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
            }
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }
    }

    private static final class HashmapNode
    extends TrieNode {
        private TrieNode[] children = new TrieNode[1];
        private char[] keys = new char[1];
        private int modulusMask = this.keys.length - 1;
        private int numEntries = 0;

        private HashmapNode() {
        }

        @Override
        public void clear() {
            this.children = new TrieNode[1];
            this.keys = new char[1];
            this.modulusMask = this.keys.length - 1;
            this.numEntries = 0;
        }

        @Override
        public TrieNode getTransition(char key) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.keys[currentSlot] == key) {
                    return this.children[currentSlot];
                }
                if (this.children[currentSlot] == null) {
                    return null;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.numEntries == 0;
        }

        @Override
        public void mapEntries(EntryVisitor visitor) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.children[i] == null) continue;
                visitor.visit(this, this.keys[i], this.children[i]);
            }
        }

        @Override
        public void updateTransition(char c, TrieNode node) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(c) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
                }
                if (this.keys[currentSlot] == c) {
                    this.children[currentSlot] = node;
                    return;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }

        @Override
        protected TrieNode optimizeNode(int level, Thresholder thresholdStrategy) {
            char minKey = '\uffff';
            char maxKey = '\u0000';
            int size = this.numEntries;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.keys[i] > maxKey) {
                    maxKey = this.keys[i];
                }
                if (this.keys[i] >= minKey) continue;
                minKey = this.keys[i];
            }
            int keyIntervalSize = maxKey - minKey + 1;
            if (thresholdStrategy.isOverThreshold(size, level, keyIntervalSize)) {
                return new RangeNode(this, minKey, maxKey);
            }
            return this;
        }

        private void enlarge() {
            char[] biggerKeys = new char[this.keys.length * 2];
            TrieNode[] biggerChildren = new TrieNode[this.children.length * 2];
            int biggerMask = biggerKeys.length - 1;
            block0: for (int i = 0; i < this.children.length; ++i) {
                int defaultSlot;
                char key = this.keys[i];
                TrieNode node = this.children[i];
                if (node == null) continue;
                int currentSlot = defaultSlot = this.hash(key) & biggerMask;
                do {
                    if (biggerChildren[currentSlot] == null) {
                        biggerKeys[currentSlot] = key;
                        biggerChildren[currentSlot] = node;
                        continue block0;
                    }
                    if (biggerKeys[currentSlot] == key) {
                        throw new IllegalStateException();
                    }
                    ++currentSlot;
                } while ((currentSlot &= biggerMask) != defaultSlot);
            }
            this.keys = biggerKeys;
            this.children = biggerChildren;
            this.modulusMask = biggerMask;
        }

        private HashmapNode getOrAddChild(char key) {
            int defaultSlot;
            if (this.keys.length < 65536 && (this.numEntries >= this.keys.length || this.numEntries > 16 && (float)this.numEntries >= (float)this.keys.length * 0.9f)) {
                this.enlarge();
            }
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    this.keys[currentSlot] = key;
                    HashmapNode newChild = new HashmapNode();
                    this.children[currentSlot] = newChild;
                    ++this.numEntries;
                    return newChild;
                }
                if (this.keys[currentSlot] == key) {
                    return (HashmapNode)this.children[currentSlot];
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalStateException();
        }

        private int hash(char c) {
            int HASH_PRIME = 16777619;
            return ((0x811C9DC5 ^ c >> 8) * 16777619 ^ c & 0xFF) * 16777619;
        }
    }

    private static interface EntryVisitor {
        public void visit(TrieNode var1, char var2, TrieNode var3);
    }
}

