/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.paper.adapters.item.components.consumable;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.MythicItem;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PaperItemConsumableComponent
extends AbstractItemConsumableComponent {
    private List<ConsumeEffect> consumeEffects;

    public PaperItemConsumableComponent(MythicItem mythicItem, MythicConfig config) {
        super(mythicItem, config);
        if (config.isSet("ConsumeEffects")) {
            this.consumeEffects = new ArrayList<ConsumeEffect>();
            for (String line : config.getStringList("ConsumeEffects")) {
                ConsumeEffect effect = PaperItemConsumableComponent.getConsumableEffect(line);
                if (effect == null) continue;
                this.consumeEffects.add(effect);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ConsumeEffect getConsumableEffect(String line) {
        MythicLineConfig config = MythicBukkit.inst().getConfiguration().createLineConfig(line);
        switch (config.getKey().toUpperCase()) {
            case "CLEARALLEFFECTS": 
            case "CLEAR_ALL_EFFECTS": 
            case "CLEARALLPOTIONS": {
                return ConsumeEffect.clearAllStatusEffects();
            }
            case "APPLYSTATUSEFFECT": 
            case "POTION": {
                String effectType = config.getString(new String[]{"type", "t"}, "SPEED", new String[0]);
                int effectDuration = config.getInteger(new String[]{"duration", "d"}, 60);
                int effectLevel = config.getInteger(new String[]{"level", "lvl", "l"}, 0);
                boolean bl = config.getBoolean(new String[]{"ambientparticles", "ambient", "a"}, false);
                boolean hasParticles = config.getBoolean(new String[]{"hasparticles", "particles", "p"}, true);
                boolean hasIcon = config.getBoolean(new String[]{"hasicon", "icon", "i"}, true);
                float probability = config.getFloat(new String[]{"probability", "chance", "c"}, 1.0f);
                PotionEffectType potionType = (PotionEffectType)RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT).get(Key.key((String)effectType.toLowerCase()));
                if (potionType == null) {
                    return null;
                }
                PotionEffect potionEffect = new PotionEffect(potionType, effectDuration, effectLevel, bl, hasParticles, hasIcon);
                return ConsumeEffect.applyStatusEffects((List)Lists.newArrayList((Object[])new PotionEffect[]{potionEffect}), (float)probability);
            }
            case "REMOVESTATUSEFFECT": 
            case "REMOVEPOTION": 
            case "CLEARPOTION": {
                List<String> effectTypes = config.getStringList(new String[]{"types", "type", "t"}, "POISON");
                ArrayList potionEffectTypes = Lists.newArrayList();
                for (String string : effectTypes) {
                    void var7_17;
                    PotionEffectType potionType;
                    if (!string.startsWith("minecraft:")) {
                        String string2 = "minecraft:" + string;
                    }
                    if ((potionType = (PotionEffectType)RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT).get(Key.key((String)var7_17.toLowerCase()))) == null) continue;
                    potionEffectTypes.add(potionType);
                }
                return ConsumeEffect.removeEffects((RegistryKeySet)RegistrySet.keySetFromValues((RegistryKey)RegistryKey.MOB_EFFECT, (Iterable)potionEffectTypes));
            }
            case "PLAYSOUND": 
            case "SOUND": {
                Object sound = config.getString(new String[]{"sound", "s"}, "minecraft:entity.ghast.scream", new String[0]);
                if (!((String)sound).startsWith("minecraft:")) {
                    sound = "minecraft:" + (String)sound;
                }
                return ConsumeEffect.playSoundConsumeEffect((Key)Key.key((String)sound));
            }
            case "TELEPORTRANDOMLY": 
            case "RANDOMTELEPORT": {
                float radius = config.getFloat(new String[]{"radius", "r"}, 8.0f);
                float diameter = config.getFloat(new String[]{"diameter", "d"}, radius * 2.0f);
                return ConsumeEffect.teleportRandomlyEffect((float)diameter);
            }
        }
        String effectType = config.getKey().toLowerCase();
        int effectDuration = config.getInteger(new String[]{"duration", "d"}, 60);
        int effectLevel = config.getInteger(new String[]{"level", "lvl", "l"}, 0);
        boolean bl = config.getBoolean(new String[]{"ambientparticles", "ambient", "a"}, false);
        boolean hasParticles = config.getBoolean(new String[]{"hasparticles", "particles", "p"}, true);
        boolean hasIcon = config.getBoolean(new String[]{"hasicon", "icon", "i"}, true);
        float probability = config.getFloat(new String[]{"probability", "chance", "c"}, 1.0f);
        PotionEffectType potionType = (PotionEffectType)RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT).get(Key.key((String)effectType));
        if (potionType == null) {
            return null;
        }
        PotionEffect potionEffect = new PotionEffect(potionType, effectDuration, effectLevel, bl, hasParticles, hasIcon);
        return ConsumeEffect.applyStatusEffects((List)Lists.newArrayList((Object[])new PotionEffect[]{potionEffect}), (float)probability);
    }

    public List<ConsumeEffect> getConsumeEffects() {
        return this.consumeEffects;
    }
}

