/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.paper;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.adapters.BukkitTeleportData;
import io.lumine.mythic.core.logging.MythicLogger;
import io.papermc.paper.entity.TeleportFlag;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PaperTeleportData
extends BukkitTeleportData {
    private PlayerTeleportEvent.TeleportCause cause;
    private TeleportFlag[] flags;

    public PaperTeleportData(MythicLineConfig config) {
        super(config);
        boolean retainVelocity;
        boolean retainOpenInv;
        boolean retainPassengers;
        String strCause = config.getString(new String[]{"teleportcause", "cause"}, "PLUGIN", new String[0]);
        try {
            this.cause = PlayerTeleportEvent.TeleportCause.valueOf((String)strCause.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            MythicLogger.error("Invalid TeleportCause \"{0}\". Falling back to PLUGIN.", strCause);
            this.cause = PlayerTeleportEvent.TeleportCause.PLUGIN;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean retainVehicle = config.getBoolean(new String[]{"retainVehicle"}, true);
        if (retainVehicle) {
            list.add(TeleportFlag.EntityState.RETAIN_VEHICLE);
        }
        if (retainPassengers = config.getBoolean(new String[]{"retainPassengers"}, true)) {
            list.add(TeleportFlag.EntityState.RETAIN_PASSENGERS);
        }
        if (retainOpenInv = config.getBoolean(new String[]{"retainOpenInventory"}, true)) {
            list.add(TeleportFlag.EntityState.RETAIN_OPEN_INVENTORY);
        }
        if (retainVelocity = config.getBoolean(new String[]{"retainVelocity"}, false)) {
            list.add(TeleportFlag.Relative.VELOCITY_X);
            list.add(TeleportFlag.Relative.VELOCITY_Y);
            list.add(TeleportFlag.Relative.VELOCITY_Z);
            list.add(TeleportFlag.Relative.VELOCITY_ROTATION);
        } else {
            if (config.getBoolean(new String[]{"relativeX"}, false)) {
                list.add(TeleportFlag.Relative.VELOCITY_X);
            }
            if (config.getBoolean(new String[]{"relativeY"}, false)) {
                list.add(TeleportFlag.Relative.VELOCITY_Y);
            }
            if (config.getBoolean(new String[]{"relativeZ"}, false)) {
                list.add(TeleportFlag.Relative.VELOCITY_Z);
            }
            if (config.getBoolean(new String[]{"relativeRotation"}, false)) {
                list.add(TeleportFlag.Relative.VELOCITY_ROTATION);
            }
        }
        this.flags = (TeleportFlag[])list.toArray(TeleportFlag[]::new);
    }

    @Override
    public void teleport(Entity entity, Location location) {
        entity.teleport(location, this.cause, this.flags);
    }
}

