/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;
import org.bukkit.util.Vector;

public class VectorVariable
extends Variable
implements ContainingVariable {
    private AbstractVector value;
    public static final VariableInfo<AbstractVector> variableInfo = VariableInfo.builder().clazz(VectorVariable.class).type(VariableType.VECTOR).typeName("Vector").valueClass(AbstractVector.class).objectConstructor(VectorVariable::ofObject).polymorphicConstructor(VectorVariable::of).toStringFunction(VectorVariable::toString).fromStringFunction(VectorVariable::fromString).formattedFunction(VectorVariable::formatted).build();

    public VariableInfo<AbstractVector> getVariableInfo() {
        return variableInfo;
    }

    public static VectorVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new VectorVariable(data.getVector(context), expirationTime);
    }

    public static String toString(AbstractVector data) {
        return data.getX() + "," + data.getY() + "," + data.getZ();
    }

    public static AbstractVector fromString(String data) {
        return VectorVariable.toVector(data);
    }

    public static String formatted(AbstractVector data) {
        return data.getX() + ", " + data.getY() + ", " + data.getZ();
    }

    public static VectorVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Vector) {
            Vector vector = (Vector)o;
            return new VectorVariable(BukkitAdapter.adapt(vector), (long)expirationTime);
        }
        if (o instanceof AbstractVector) {
            AbstractVector vector = (AbstractVector)o;
            return new VectorVariable(vector, (long)expirationTime);
        }
        return new VectorVariable(String.valueOf(o), (long)expirationTime);
    }

    public VectorVariable(AbstractVector value) {
        this.build(value);
    }

    public VectorVariable(String rawData) {
        this.build(VectorVariable.toVector(rawData));
    }

    public VectorVariable(AbstractVector value, long expirationTime) {
        super(expirationTime);
        this.build(value);
    }

    public VectorVariable(String rawData, long expirationTime) {
        super(expirationTime);
        this.build(VectorVariable.toVector(rawData));
    }

    public static AbstractVector toVector(String rawData) {
        if (rawData == null || rawData.trim().isEmpty()) {
            return new AbstractVector(0, 0, 0);
        }
        String[] split = rawData.trim().split(",");
        if (split.length == 3) {
            try {
                double x = Double.parseDouble(split[0].trim());
                double y = Double.parseDouble(split[1].trim());
                double z = Double.parseDouble(split[2].trim());
                return new AbstractVector(x, y, z);
            }
            catch (NumberFormatException e) {
                return new AbstractVector(0, 0, 0);
            }
        }
        return new AbstractVector(0, 0, 0);
    }

    private void build(AbstractVector value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    @Override
    public AbstractVector get() {
        return this.value;
    }

    @Override
    public AbstractVector getValueClone() {
        return this.value.clone();
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        AbstractVector vec = data.getVector(context);
        this.value.add(vec);
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        AbstractVector vec = data.getVector(context);
        this.value.subtract(vec);
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        AbstractVector vec = data.getVector(context);
        return this.value.equals(vec);
    }

    @Override
    public boolean checkContainsAll(PolymorphicPlaceholder data, PlaceholderContext context) {
        AbstractVector vec = data.getVector(context);
        if (vec == null) {
            return false;
        }
        AbstractVector thisNormalized = this.value.clone().normalize();
        AbstractVector otherNormalized = vec.normalize();
        if (thisNormalized.lengthSquared() == 0.0 && otherNormalized.lengthSquared() == 0.0) {
            return true;
        }
        return thisNormalized.equals(otherNormalized);
    }

    @Override
    public String toString() {
        return VectorVariable.toString(this.value);
    }

    @Override
    public Variable clone() {
        AbstractVector newVector = new AbstractVector(this.value.getX(), this.value.getY(), this.value.getZ());
        return new VectorVariable(newVector);
    }

    @Override
    public String formatted() {
        return this.value.getX() + ", " + this.value.getY() + ", " + this.value.getZ();
    }

    public AbstractVector getValue() {
        return this.value;
    }

    public void setValue(AbstractVector value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorVariable)) {
            return false;
        }
        VectorVariable other = (VectorVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbstractVector this$value = this.getValue();
        AbstractVector other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbstractVector $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

