/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;
import io.lumine.mythic.core.skills.variables.interfaces.NumericVariable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class TimeVariable
extends Variable
implements NumericVariable,
ContainingVariable {
    private Instant value;
    public static final VariableInfo<Instant> variableInfo = VariableInfo.builder().clazz(TimeVariable.class).type(VariableType.TIME).typeName("Time").valueClass(Instant.class).objectConstructor(TimeVariable::ofObject).polymorphicConstructor(TimeVariable::of).toStringFunction(TimeVariable::toString).fromStringFunction(TimeVariable::fromString).build();

    public VariableInfo<Instant> getVariableInfo() {
        return variableInfo;
    }

    public static TimeVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new TimeVariable(data.getTime(context), expirationTime);
    }

    public static String toString(Instant data) {
        return "" + data.toEpochMilli();
    }

    public static Instant fromString(String data) {
        return Instant.ofEpochMilli(Long.parseLong(data));
    }

    public static TimeVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Instant) {
            Instant instant = (Instant)o;
            return new TimeVariable(instant.toEpochMilli(), (long)expirationTime);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new TimeVariable(number.longValue(), (long)expirationTime);
        }
        return new TimeVariable(String.valueOf(o), (long)expirationTime);
    }

    public TimeVariable(String value) {
        this.build(value);
    }

    public TimeVariable(Instant value) {
        this.value = value;
    }

    public TimeVariable(String value, long expirationTime) {
        super(expirationTime);
        this.build(value);
    }

    public TimeVariable(Instant value, long expirationTime) {
        super(expirationTime);
        this.value = value;
    }

    public TimeVariable(long value, long expirationTime) {
        super(expirationTime);
        this.value = Instant.ofEpochMilli(value);
    }

    private void build(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = TimeVariable.fromString(value);
    }

    private static Instant getInstant(long time) {
        return Instant.ofEpochMilli(time);
    }

    public static String getFormattedTime(long time, String zoneOffset) {
        return TimeVariable.getInstant(time).atOffset(ZoneOffset.of(zoneOffset)).toString();
    }

    public static long getTimeDelta(Instant time, Instant secondTime) {
        return time.until(secondTime, ChronoUnit.MILLIS);
    }

    public static String appendTime(long time, String unit) {
        if (time == 0L) {
            return "";
        }
        if (time == 1L) {
            return time + " " + unit + " ";
        }
        return time + " " + unit + "s ";
    }

    public static String getFormattedDuration(long time) {
        long totalSeconds = time / 1000L;
        long secondsInYear = 31556951L;
        long secondsInMonth = 2630016L;
        long secondsInDay = 86400L;
        long secondsInHour = 3600L;
        long secondsInMinute = 60L;
        long years = totalSeconds / secondsInYear;
        long months = (totalSeconds %= secondsInYear) / secondsInMonth;
        long days = (totalSeconds %= secondsInMonth) / secondsInDay;
        long hours = (totalSeconds %= secondsInDay) / secondsInHour;
        long minutes = (totalSeconds %= secondsInHour) / secondsInMinute;
        long seconds = totalSeconds % secondsInMinute;
        Object ret = "";
        ret = (String)ret + TimeVariable.appendTime(years, "Year");
        ret = (String)ret + TimeVariable.appendTime(months, "Month");
        ret = (String)ret + TimeVariable.appendTime(days, "Day");
        ret = (String)ret + TimeVariable.appendTime(hours, "Hour");
        ret = (String)ret + TimeVariable.appendTime(minutes, "Minute");
        ret = (String)ret + TimeVariable.appendTime(seconds, "Second");
        return ret;
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value = this.value.plusMillis(data.getTime(context).toEpochMilli());
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value = this.value.minusMillis(data.getTime(context).toEpochMilli());
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        return this.value.toEpochMilli() == data.getTime(context).toEpochMilli();
    }

    @Override
    public boolean checkContainsAll(PolymorphicPlaceholder data, PlaceholderContext context) {
        return this.value.toEpochMilli() >= data.getTime(context).toEpochMilli();
    }

    @Override
    public Instant get() {
        return this.value;
    }

    @Override
    public Instant getValueClone() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value.toEpochMilli());
    }

    @Override
    public String formatted() {
        return TimeVariable.getFormattedDuration(this.value.toEpochMilli());
    }

    @Override
    public void executeMath(String eq) {
        this.value = Instant.ofEpochMilli((long)this.parseMath(eq, this.value.toEpochMilli()));
    }

    public Instant getValue() {
        return this.value;
    }

    public void setValue(Instant value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeVariable)) {
            return false;
        }
        TimeVariable other = (TimeVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$value = this.getValue();
        Instant other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

