/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.NumericVariable;
import java.util.Objects;

public class LongVariable
extends Variable
implements NumericVariable {
    private Long value;
    public static final VariableInfo<Long> variableInfo = VariableInfo.builder().clazz(LongVariable.class).type(VariableType.LONG).typeName("Long").valueClass(Long.class).objectConstructor(LongVariable::ofObject).polymorphicConstructor(LongVariable::of).toStringFunction(LongVariable::toString).fromStringFunction(LongVariable::fromString).build();

    public VariableInfo<Long> getVariableInfo() {
        return variableInfo;
    }

    public static LongVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new LongVariable(data.getLong(context), expirationTime);
    }

    public static String toString(Long data) {
        return Long.toString(data);
    }

    public static Long fromString(String data) {
        return Long.parseLong(data);
    }

    public static LongVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Number) {
            Number numberNumber = (Number)o;
            return new LongVariable(numberNumber.longValue(), (long)expirationTime);
        }
        return new LongVariable(String.valueOf(o), (long)expirationTime);
    }

    public LongVariable(long value) {
        this.value = value;
    }

    public LongVariable(long value, long expirationTime) {
        super(expirationTime);
        this.value = value;
    }

    public LongVariable(String value) {
        this(LongVariable.fromString(value));
    }

    public LongVariable(String value, long expirationTime) {
        this(LongVariable.fromString(value), expirationTime);
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public Long getValueClone() {
        return this.value;
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value = this.value + data.getLong(context);
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value = this.value - data.getLong(context);
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        return Objects.equals(this.value, data.getLong(context));
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public void executeMath(String eq) {
        this.value = (long)this.parseMath(eq, this.value.longValue());
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongVariable)) {
            return false;
        }
        LongVariable other = (LongVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$value = this.getValue();
        Long other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

