/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.NumericVariable;

public class FloatVariable
extends Variable
implements NumericVariable {
    private float value;
    public static final VariableInfo<Float> variableInfo = VariableInfo.builder().clazz(FloatVariable.class).type(VariableType.FLOAT).typeName("Float").valueClass(Float.class).objectConstructor(FloatVariable::ofObject).polymorphicConstructor(FloatVariable::of).toStringFunction(FloatVariable::toString).fromStringFunction(FloatVariable::fromString).build();

    public VariableInfo<Float> getVariableInfo() {
        return variableInfo;
    }

    public static FloatVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new FloatVariable(data.getFloat(context), expirationTime);
    }

    public static String toString(Float data) {
        return Float.toString(data.floatValue());
    }

    public static Float fromString(String data) {
        return Float.valueOf(Float.parseFloat(data));
    }

    public static FloatVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Number) {
            Number numberNumber = (Number)o;
            return new FloatVariable(numberNumber.floatValue(), (long)expirationTime);
        }
        return new FloatVariable(String.valueOf(o), (long)expirationTime);
    }

    public FloatVariable(float value) {
        this.value = value;
    }

    public FloatVariable(float value, long expirationTime) {
        super(expirationTime);
        this.value = value;
    }

    public FloatVariable(String value) {
        this(FloatVariable.fromString(value).floatValue());
    }

    public FloatVariable(String value, long expirationTime) {
        this(FloatVariable.fromString(value).floatValue(), expirationTime);
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    @Override
    public Float getValueClone() {
        return Float.valueOf(this.value);
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value += data.getFloat(context);
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value -= data.getFloat(context);
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        float newValue = data.getFloat(context);
        return newValue == this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public void executeMath(String eq) {
        this.value = (float)this.parseMath(eq, this.value);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatVariable)) {
            return false;
        }
        FloatVariable other = (FloatVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FloatVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getValue());
        return result;
    }
}

