/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.types.AbstractVariable;
import io.lumine.mythic.core.skills.variables.types.BooleanVariable;
import io.lumine.mythic.core.skills.variables.types.DoubleVariable;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import io.lumine.mythic.core.skills.variables.types.ItemVariable;
import io.lumine.mythic.core.skills.variables.types.ListVariable;
import io.lumine.mythic.core.skills.variables.types.LocationVariable;
import io.lumine.mythic.core.skills.variables.types.LongVariable;
import io.lumine.mythic.core.skills.variables.types.MapVariable;
import io.lumine.mythic.core.skills.variables.types.MetaSkillVariable;
import io.lumine.mythic.core.skills.variables.types.SetVariable;
import io.lumine.mythic.core.skills.variables.types.StringVariable;
import io.lumine.mythic.core.skills.variables.types.TimeVariable;
import io.lumine.mythic.core.skills.variables.types.VectorVariable;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VariableUtils {
    public static final Map<String, VariableInfo<?>> variableInfoByTypeName = new ConcurrentHashMap();
    public static final Map<VariableType, VariableInfo<?>> variableInfoByType = new EnumMap(VariableType.class);
    public static final Map<Class<? extends Variable>, VariableInfo<?>> variableInfoByClass = new ConcurrentHashMap();
    public static final Map<Class<?>, VariableInfo<?>> variableInfoByValueClass = new ConcurrentHashMap();
    public static final Map<String, VariableInfo<?>> defaultVariablesPrefixes = new ConcurrentHashMap();

    public static <T, K> boolean registerOnMapUtil(Map<T, K> map, T key, K value) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, value);
        return true;
    }

    public static Variable createVariableFromPrefixedValue(String value) {
        for (Map.Entry<String, VariableInfo<?>> entry : defaultVariablesPrefixes.entrySet()) {
            if (!value.toLowerCase().startsWith(entry.getKey())) continue;
            return entry.getValue().objectConstructor().apply(value.substring(entry.getKey().length()), 0L);
        }
        if (value.startsWith("int/")) {
            int val = Integer.parseInt(value.substring(4));
            return new IntegerVariable(val, 0L);
        }
        return new StringVariable(value, 0L);
    }

    public static VariableType getType(Class<? extends Variable> clazz) {
        VariableInfo<?> info = variableInfoByClass.get(clazz);
        if (info == null || info.type() == null) {
            throw new IllegalArgumentException("Invalid variable class (" + clazz.getName() + ").");
        }
        return info.type();
    }

    public static String getTypeName(Class<? extends Variable> clazz) {
        VariableInfo<?> info = variableInfoByClass.get(clazz);
        if (info == null) {
            throw new IllegalArgumentException("Invalid variable class (" + clazz.getName() + ").");
        }
        return info.typeName();
    }

    public static Class<? extends Variable> getTypeClass(String type) {
        VariableInfo<?> info = variableInfoByTypeName.get(type);
        if (info == null || info.clazz() == null) {
            throw new IllegalArgumentException("Invalid variable type : " + type + ".");
        }
        return info.clazz();
    }

    public static <T> void registerVariable(VariableInfo<T> variableInfo) {
        variableInfoByTypeName.put(variableInfo.typeName(), variableInfo);
        variableInfoByType.put(variableInfo.type(), variableInfo);
        variableInfoByClass.put(variableInfo.clazz(), variableInfo);
        variableInfoByValueClass.put(variableInfo.valueClass(), variableInfo);
        defaultVariablesPrefixes.put(variableInfo.typeName().toLowerCase() + "/", variableInfo);
    }

    static {
        VariableUtils.registerVariable(AbstractVariable.variableInfo);
        VariableUtils.registerVariable(BooleanVariable.variableInfo);
        VariableUtils.registerVariable(DoubleVariable.variableInfo);
        VariableUtils.registerVariable(FloatVariable.variableInfo);
        VariableUtils.registerVariable(IntegerVariable.variableInfo);
        VariableUtils.registerVariable(LongVariable.variableInfo);
        VariableUtils.registerVariable(ItemVariable.variableInfo);
        VariableUtils.registerVariable(ListVariable.variableInfo);
        VariableUtils.registerVariable(LocationVariable.variableInfo);
        VariableUtils.registerVariable(MapVariable.variableInfo);
        VariableUtils.registerVariable(MetaSkillVariable.variableInfo);
        VariableUtils.registerVariable(SetVariable.variableInfo);
        VariableUtils.registerVariable(StringVariable.variableInfo);
        VariableUtils.registerVariable(TimeVariable.variableInfo);
        VariableUtils.registerVariable(VectorVariable.variableInfo);
    }

    @FunctionalInterface
    public static interface VariablePolymorphicFactory<T extends Variable> {
        public T create(PolymorphicPlaceholder var1, PlaceholderContext var2, long var3);
    }

    @FunctionalInterface
    public static interface VariableFromStringFactory<T> {
        public T convert(String var1);
    }

    @FunctionalInterface
    public static interface VariableToStringFactory<T> {
        public String convert(T var1);
    }
}

