/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters.shapes;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.targeters.shapes.ITargeterShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public class SphereShape
implements ITargeterShape {
    private final PlaceholderDouble radius;

    public SphereShape(MythicLineConfig config) {
        this.radius = PlaceholderDouble.of(config.getString(new String[]{"radius", "r"}, "5", new String[0]));
        boolean onlyLiving = config.getBoolean(new String[]{"livingonly", "living", "l"}, true);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data, AbstractLocation origin) {
        return this.getEntities(data, origin, null);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data, AbstractLocation origin, Predicate<AbstractEntity> extraFilter) {
        double r = this.radius.get(data);
        double rSq = r * r;
        Collection<AbstractEntity> candidates = origin.getWorld().getEntitiesNearLocation(origin, r);
        ArrayList<AbstractEntity> result = new ArrayList<AbstractEntity>();
        for (AbstractEntity e : candidates) {
            double dz;
            double dy;
            double dx = e.getLocation().getX() - origin.getX();
            if (dx * dx + (dy = e.getLocation().getY() - origin.getY()) * dy + (dz = e.getLocation().getZ() - origin.getZ()) * dz > rSq || extraFilter != null && !extraFilter.test(e)) continue;
            result.add(e);
        }
        return result;
    }
}

