/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters.shapes;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.targeters.shapes.ITargeterShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public class CylinderShape
implements ITargeterShape {
    private final PlaceholderDouble radius;
    private final PlaceholderDouble height;
    private final PlaceholderDouble yOffset;

    public CylinderShape(MythicLineConfig config) {
        this.radius = PlaceholderDouble.of(config.getString(new String[]{"radius", "r"}, "5", new String[0]));
        this.height = PlaceholderDouble.of(config.getString(new String[]{"height", "h"}, "5", new String[0]));
        this.yOffset = PlaceholderDouble.of(config.getString(new String[]{"yOffset", "offsetY", "yo"}, "0", new String[0]));
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data, AbstractLocation origin) {
        return this.getEntities(data, origin, null);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data, AbstractLocation origin, Predicate<AbstractEntity> extraFilter) {
        double r = this.radius.get(data);
        double h2 = this.height.get(data);
        double yOff = this.yOffset.get(data);
        double rSq = r * r;
        Collection<AbstractEntity> candidates = origin.getWorld().getEntitiesNearLocation(origin, r);
        ArrayList<AbstractEntity> result = new ArrayList<AbstractEntity>();
        double minY = origin.getY() + yOff;
        double maxY = minY + h2;
        for (AbstractEntity e : candidates) {
            double dz;
            double x = e.getLocation().getX();
            double y = e.getLocation().getY();
            double z = e.getLocation().getZ();
            double dx = x - origin.getX();
            if (dx * dx + (dz = z - origin.getZ()) * dz > rSq || y < minY || y > maxY || extraFilter != null && !extraFilter.test(e)) continue;
            result.add(e);
        }
        return result;
    }
}

